/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.gemini.web.core.ConnectorDescriptor;
import org.eclipse.gemini.web.core.WebContainerProperties;
import org.eclipse.gemini.web.tomcat.internal.TomcatConnectorDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TomcatWebContainerProperties
implements WebContainerProperties {
    private static final String CATALINA_TYPE_PROTOCOL_HANDLER = "Catalina:type=ProtocolHandler,*";
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatWebContainerProperties.class);
    private static final String ATTRIBUTE_MODELER_TYPE = "modelerType";
    private static final String ATTRIBUTE_SSL_ENABLED = "sSLEnabled";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PORT = "port";

    TomcatWebContainerProperties() {
    }

    public Set<ConnectorDescriptor> getConnectorDescriptors() {
        HashSet<ConnectorDescriptor> connectorDescriptors = new HashSet<ConnectorDescriptor>();
        MBeanServer mBeanServer = this.getMBeanServer();
        try {
            ObjectName portNamesQuery = new ObjectName(CATALINA_TYPE_PROTOCOL_HANDLER);
            Set<ObjectName> portMBeanNames = mBeanServer.queryNames(portNamesQuery, null);
            for (ObjectName objectName : portMBeanNames) {
                Object attribute = this.getAttribute(mBeanServer, objectName, ATTRIBUTE_MODELER_TYPE);
                Object modler = attribute == null ? "" : attribute;
                attribute = this.getAttribute(mBeanServer, objectName, ATTRIBUTE_SSL_ENABLED);
                Object sslEnabled = attribute == null ? Boolean.valueOf(false) : attribute;
                attribute = this.getAttribute(mBeanServer, objectName, ATTRIBUTE_NAME);
                Object name = attribute == null ? "" : attribute;
                attribute = objectName.getKeyProperty(ATTRIBUTE_PORT);
                Object port = attribute == null ? Integer.valueOf(-1) : attribute;
                connectorDescriptors.add(new TomcatConnectorDescriptor(modler.toString(), name.toString(), Integer.valueOf(port.toString()), Boolean.valueOf(sslEnabled.toString())));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to obtain the Tomcat port number from its MBeans", (Throwable)e);
        }
        return connectorDescriptors;
    }

    private MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private Object getAttribute(MBeanServer mBeanServer, ObjectName objectName, String attributeName) {
        try {
            return mBeanServer.getAttribute(objectName, attributeName);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

