/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.naming.NamingEntry;
import org.eclipse.gemini.web.tomcat.internal.loading.AbstractReadOnlyDirContext;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntry;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntryAttributes;
import org.eclipse.gemini.web.tomcat.internal.loading.URLResource;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleDirContext
extends AbstractReadOnlyDirContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleDirContext.class);
    private volatile BundleEntry bundleEntry;

    public BundleDirContext(Bundle bundle) {
        this(new BundleEntry(bundle));
    }

    private BundleDirContext(BundleEntry bundleEntry) {
        this.bundleEntry = bundleEntry;
    }

    public List<NamingEntry> doListBindings(String name) throws NamingException {
        try {
            return this.doSafeList(name);
        }
        catch (NameNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Name '" + name + "' does not exist.", (Throwable)e);
            }
            return null;
        }
    }

    public Object doLookup(String name) {
        try {
            Map.Entry<BundleEntry, URL> entry = this.getNamedEntry(name);
            return this.entryToResult(entry.getKey(), entry.getValue());
        }
        catch (NamingException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("", (Throwable)e);
            }
            return null;
        }
    }

    private List<NamingEntry> doSafeList(String name) throws NamingException {
        Map.Entry<BundleEntry, URL> entry = this.getNamedEntry(name);
        return this.doList(entry.getKey());
    }

    private Map.Entry<BundleEntry, URL> getNamedEntry(String name) throws NamingException {
        this.checkCanLookup(name);
        Map.Entry<BundleEntry, URL> namedEntry = this.bundleEntry.getEntry(name);
        if (namedEntry == null) {
            throw new NameNotFoundException("Name '" + name + "' does not exist.");
        }
        return namedEntry;
    }

    private List<NamingEntry> doList(BundleEntry bundleEntry) {
        List<BundleEntry> list = bundleEntry.list();
        ArrayList<NamingEntry> resources = new ArrayList<NamingEntry>();
        for (BundleEntry entry : list) {
            Object object = this.entryToResult(entry);
            resources.add(new NamingEntry(entry.getName(), object, 0));
        }
        return resources;
    }

    private Object entryToResult(BundleEntry entry) {
        return this.entryToResult(entry, entry.getURL());
    }

    private Object entryToResult(BundleEntry entry, URL url) {
        Object result = BundleEntry.isDirectory(url) ? new BundleDirContext(entry) : new URLResource(url);
        return result;
    }

    private void checkCanLookup(String name) throws NamingException {
        BundleEntry entry = this.bundleEntry;
        if (entry == null || entry.getBundle().getState() == 1) {
            throw new NamingException("Resource not found '" + name + "'");
        }
        this.checkNotAttemptingToLookupFromProtectedLocation(name);
    }

    private void checkNotAttemptingToLookupFromProtectedLocation(String name) throws NamingException {
        this.checkNotAttemptingToLookupFrom(name, "/OSGI-INF/");
        this.checkNotAttemptingToLookupFrom(name, "/OSGI-OPT/");
    }

    private void checkNotAttemptingToLookupFrom(String name, String prefix) throws NamingException {
        if (name.startsWith(prefix)) {
            throw new NamingException("Resource cannot be obtained from " + prefix);
        }
    }

    public void close() throws NamingException {
        super.close();
        this.bundleEntry = null;
    }

    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        try {
            Map.Entry<BundleEntry, URL> entry = this.getNamedEntry(name);
            return new BundleEntryAttributes(entry.getKey(), attrIds, entry.getValue());
        }
        catch (NameNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Name '" + name + "' does not exist.", (Throwable)e);
            }
            return null;
        }
    }

    protected String doGetRealPath(String path) {
        if (this.bundleEntry.isBundleLocationDirectory()) {
            boolean checkInBundleLocation = path != null && path.indexOf("..") >= 0;
            String bundleLocationCanonicalPath = this.bundleEntry.getBundleLocationCanonicalPath();
            File entry = new File(bundleLocationCanonicalPath, path);
            if (checkInBundleLocation) {
                try {
                    if (!entry.getCanonicalPath().startsWith(bundleLocationCanonicalPath)) {
                        return null;
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return entry.getAbsolutePath();
        }
        return null;
    }
}

