/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.antlr.action;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.IComboZoom;
import fr.inria.aoste.timesquare.vcd.antlr.IToolBarAPI;
import java.util.ArrayList;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ComboContributionItem
extends ContributionItem
implements IComboZoom {
    ArrayList<Double> _arraylistDouble = new ArrayList();
    Combo _combo = null;
    IToolBarAPI _toolBarAPI = null;
    private ToolItem toolitem;

    public ComboContributionItem(IToolBarAPI tba) {
        this._toolBarAPI = tba;
        this._arraylistDouble.add(6.25);
        this._arraylistDouble.add(12.5);
        this._arraylistDouble.add(25.0);
        this._arraylistDouble.add(50.0);
        this._arraylistDouble.add(100.0);
        this._arraylistDouble.add(200.0);
        this._arraylistDouble.add(300.0);
        this._arraylistDouble.add(400.0);
    }

    protected Control createControl(Composite parent) {
        this._combo = new Combo(parent, 4);
        this._combo.addSelectionListener((SelectionListener)new ComboSelectionListener());
        this._combo.addFocusListener((FocusListener)new RenameFocusListener());
        this.updateitem();
        this.select(100.0);
        if (this.toolitem != null) {
            this.toolitem.setWidth(80);
        }
        return this._combo;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    public boolean isEnabled() {
        return this._toolBarAPI.getCurrentVcd() != null;
    }

    public int select(Double d) {
        int n = 0;
        n = this._arraylistDouble.indexOf(d);
        if (n != -1) {
            this._combo.select(n);
            this._combo.setToolTipText("Zoom in " + d + " % for VCD");
            return 1;
        }
        n = 0;
        for (double _doubleElement : this._arraylistDouble) {
            if (_doubleElement > d) break;
            ++n;
        }
        this._arraylistDouble.add(n, d);
        this.updateitem();
        n = this._arraylistDouble.indexOf(d);
        this._combo.select(n);
        this._combo.setToolTipText("Zoom in " + d + " % for VCD");
        return 0;
    }

    public int updateitem() {
        this._combo.removeAll();
        ArrayList<String> _arraylistString = new ArrayList<String>();
        for (Double _doubleElement : this._arraylistDouble) {
            _arraylistString.add(_doubleElement.toString());
        }
        this._combo.setItems(_arraylistString.toArray(new String[_arraylistString.size()]));
        return 0;
    }

    public int updateFocus() {
        if (this._combo == null) {
            return -1;
        }
        if (this._toolBarAPI == null) {
            return -1;
        }
        if (this._toolBarAPI.getCurrentVcd() == null) {
            return -1;
        }
        if (this._combo.isDisposed()) {
            return -1;
        }
        this._combo.removeAll();
        this._combo.setItems(this._toolBarAPI.getCurrentVcd().getVcdzoom().getZoomlist().arrayOf());
        this._combo.select(this._toolBarAPI.getCurrentVcd().getVcdzoom().getZoomlist().getIndice());
        return 0;
    }

    public final class ComboSelectionListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                if (ComboContributionItem.this._toolBarAPI.getCurrentVcd() == null) {
                    return;
                }
                Double old = ComboContributionItem.this._toolBarAPI.getCurrentVcd().getTraceZoomValue();
                String s = ((Combo)e.getSource()).getText();
                if (s == null) {
                    return;
                }
                if (s.length() == 0) {
                    return;
                }
                Double d = Double.parseDouble(s) / 100.0;
                if (d < 0.001 || d > 5000.0) {
                    ErrorConsole.println((String)"Zoom : Out of order");
                    return;
                }
                ComboContributionItem.this._toolBarAPI.getCurrentVcd().setZoomValue(old / d);
                ComboContributionItem.this._toolBarAPI.getCurrentVcd().setTcZoom(d.doubleValue());
                ComboContributionItem.this._toolBarAPI.getCurrentVcd().getVcdzoom().applyClickZoom();
            }
            catch (Exception ex) {
                ErrorConsole.printError((Throwable)ex);
            }
        }
    }

    public static final class RenameFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

