/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.draw.print;

import fr.inria.aoste.timesquare.vcd.draw.FigureCanvasBase;
import fr.inria.aoste.timesquare.vcd.preferences.VcdColorPreferences;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintOperation;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FigurePrinter
extends PrintOperation {
    private FigureCanvasBase _figureCanvasBase = null;
    private VcdColorPreferences _mca = null;

    public FigurePrinter() {
    }

    public FigurePrinter(Printer p) {
        super(p);
    }

    public void setFigureCanvasBase(FigureCanvasBase fcbin) {
        this._figureCanvasBase = fcbin;
        this._mca = this._figureCanvasBase.getMca();
    }

    public int clear() {
        this.cleanup();
        this._figureCanvasBase = null;
        this._mca = null;
        return 0;
    }

    protected void printPages() {
        PrinterGraphics graphics = this.getFreshPrinterGraphics();
        int size = this._mca.getWidthName();
        int dy = this._figureCanvasBase.getScaleCanvas().getContents().getSize().height;
        this.setupPrinterGraphicsFor((Graphics)graphics, this._figureCanvasBase.getClockCanvas().getContents(), size, dy);
        graphics.pushState();
        this.getPrinter().startPage();
        Dimension d = new Dimension(this._figureCanvasBase.getClockCanvas().getContents().getSize()).expand(size, dy);
        graphics.clipRect(new Rectangle(new Point(0, 0), d));
        this.printfigure(graphics, this._figureCanvasBase.getNames().getContents(), 0, dy);
        this.printfigure(graphics, this._figureCanvasBase.getClockCanvas().getContents(), size, 0);
        this.printfigure(graphics, this._figureCanvasBase.getScaleCanvas().getContents(), 0, -dy);
        this.getPrinter().endPage();
        graphics.popState();
    }

    private int printfigure(PrinterGraphics g, IFigure figure, int x, int y) {
        g.translate(new Point(x, y));
        figure.paint((Graphics)g);
        return 0;
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure, int x, int y) {
        double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
        Rectangle printRegion = this.getPrintRegion();
        Rectangle bounds = figure.getBounds();
        bounds.width += x;
        bounds.height += y;
        double xScale = (double)printRegion.width / ((double)bounds.width * 1.05 * dpiScale);
        double yScale = (double)printRegion.height / ((double)bounds.height * 1.05 * dpiScale);
        graphics.scale(Math.min(xScale, yScale) * dpiScale);
        graphics.setForegroundColor(this._mca.colorBlack());
        graphics.setBackgroundColor(this._mca.colorBlack());
        graphics.setFont(figure.getFont());
    }

    public void run(String jobName) {
        if (MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question...", (String)("Really print " + this.getNumofPages() + " pages on " + this.getPrinter().getPrinterData().name + " ( Beta Fonction )" + "?"))) {
            super.run(jobName);
        }
    }

    private int getNumofPages() {
        return 1;
    }
}

