/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.listener;

import fr.inria.aoste.timesquare.vcd.IVcdDiagram;
import fr.inria.aoste.timesquare.vcd.figure.ConstraintsConnection;
import fr.inria.aoste.timesquare.vcd.model.Description;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.ToolItem;

public class MouseMoveListenerVCD
implements MouseMoveListener {
    private IVcdDiagram vcd = null;

    public MouseMoveListenerVCD(IVcdDiagram vcd) {
        this.vcd = vcd;
    }

    public void mouseMove(MouseEvent e) {
        try {
            int xscroll = this.vcd.getfcb().getClockCanvas().getHorizontalBar().getSelection();
            int yscroll = this.vcd.getfcb().getClockCanvas().getVerticalBar().getSelection();
            IFigure fig = this.vcd.getfcb().getClockCanvas().getContents().findFigureAt(e.x + xscroll, e.y + yscroll);
            if (fig != null) {
                if (fig instanceof PolylineConnection || fig instanceof Label) {
                    ConstraintsConnection poly;
                    Description descr;
                    this.vcd.getConstraintsFactory().showConstraint(fig);
                    if (fig instanceof PolylineConnection && (descr = this.vcd.getVcdFactory().getFigureForDescription(fig)) != null && descr.getDescription() != null && descr.getIndex() >= 0) {
                        this.vcd.getfcb().getClockCanvas().setToolTipText(String.valueOf(descr.getAlias()) + "[" + (descr.getIndex() + 1) + "]");
                    }
                    if (fig instanceof ConstraintsConnection && (poly = (ConstraintsConnection)fig).getComment() != null) {
                        if (this.vcd.getToolbar().getItems().length <= 0) {
                            new ToolItem(this.vcd.getToolbar(), 8);
                        }
                        ToolItem item = this.vcd.getToolbar().getItems()[0];
                        item.setText(poly.getComment().toString());
                    }
                } else {
                    this.vcd.getfcb().getClockCanvas().setToolTipText(null);
                    this.vcd.getConstraintsFactory().hideConstraints();
                    this.vcd.getConstraintsFactory().hideCoincidence();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

