/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.preferences;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.preferences.ColorSelection;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public final class VcdColorPreferences {
    private static VcdColorPreferences DEFAULT;
    private ColorSelection selection = null;
    private ColorSelection selectionprint = null;
    private ListColor ls1;
    private ListColor ls2;
    private ListColor ls;
    boolean mode = true;

    protected ColorSelection getSelectionprint() {
        return this.selectionprint;
    }

    protected ColorSelection getSelection() {
        return this.selection;
    }

    public int updatecolor() {
        return this.ls.setcolor();
    }

    private VcdColorPreferences create() {
        return new VcdColorPreferences(this.selection, this.selectionprint);
    }

    public static synchronized VcdColorPreferences createColor() {
        return VcdColorPreferences.getDefault().create();
    }

    protected static synchronized VcdColorPreferences getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new VcdColorPreferences();
        }
        return DEFAULT;
    }

    public boolean isMode() {
        return this.mode;
    }

    public void setMode(boolean mode) {
        this.ls = mode ? this.ls1 : this.ls2;
        this.mode = mode;
    }

    private VcdColorPreferences(ColorSelection col, ColorSelection colprint) {
        this.selection = col;
        this.selectionprint = colprint;
        this.ls1 = new ListColor(this.selection);
        this.ls2 = new ListColor(this.selectionprint);
        this.setMode(true);
    }

    private VcdColorPreferences() {
        this.selection = new ColorSelection("vcd");
        this.ls1 = new ListColor(this.selection);
        this.selectionprint = new ColorSelection("print");
        this.ls2 = new ListColor(this.selectionprint);
        this.getSelection().init();
        this.getSelectionprint().init();
        this.setMode(true);
    }

    public Color colorMenuBackground() {
        return ColorConstants.menuBackground;
    }

    public Color colorBlack() {
        return this.ls.colorBack;
    }

    public Color colorTextToolTip() {
        return ColorConstants.white;
    }

    public Color colorYellowTooltip() {
        return ColorConstants.yellow;
    }

    public Color colorWhiteArrow() {
        return this.ls.colorWhiteArrow;
    }

    public Color colorWhiteRule() {
        return this.ls.colorWhiteRule;
    }

    public Color colorWhiteText() {
        return this.ls.colorWhiteText;
    }

    public Color colorRedRule() {
        return ColorConstants.red;
    }

    public Color colorRedFind() {
        return ColorConstants.red;
    }

    public Color colorRedTime() {
        return this.ls.colorRedTime;
    }

    public Color colorRedTimeXor() {
        RGB rbg = this.ls.colorRedTime.getRGB();
        RGB rbg2 = this.ls.colorBack.getRGB();
        return new Color(null, rbg.red ^ rbg2.red, rbg.green ^ rbg2.green, rbg.blue ^ rbg2.blue);
    }

    public Color colorWeakyCoincidence() {
        return this.ls.colorweaklyPrecedes;
    }

    public Color colorRedCoincidence() {
        return this.ls.colorRedCoincidence;
    }

    public Color colorGhostClock() {
        return this.ls.colorGhostClock;
    }

    public Color colorClock() {
        return this.ls.colorClock;
    }

    public Color colorTimer() {
        return this.ls.colorTimer;
    }

    public Color colorTimerText() {
        return this.ls.colorTimertext;
    }

    public Color colorLightGrayClockNameContour() {
        return ColorConstants.lightGray;
    }

    public Color colorLightGraySync() {
        return ColorConstants.lightGray;
    }

    public Color colorLightBlueSync() {
        return ColorConstants.lightBlue;
    }

    public Color colorRedSync() {
        return ColorConstants.red;
    }

    public Color colorYellowZ() {
        return this.ls.colorYellowZ;
    }

    public Color colorTimerZ() {
        return this.ls.colorTimerZ;
    }

    public Color colorTickMarker() {
        return this.ls.colorpacket;
    }

    public Color colorBlueSustain() {
        return this.ls.colorpacket;
    }

    public Color colorDarkGreenGhostFireable() {
        return ColorConstants.darkGreen;
    }

    public Color colorLightGreenFirable() {
        return ColorConstants.lightGreen;
    }

    public int getWidthName() {
        return this.ls.width;
    }

    protected void finalize() throws Throwable {
        System.out.println("Delete MYcolorAPI");
        ErrorConsole.printOKln((String)"Delete MYcolorAPI");
        super.finalize();
    }

    private static class ListColor {
        private ColorSelection sel;
        private Color colorWhiteRule;
        private Color colorWhiteText;
        private Color colorRedTime;
        private Color colorBack;
        private Color colorGhostClock;
        private Color colorYellowZ;
        private Color colorTimer;
        private Color colorTimertext;
        private Color colorWhiteArrow;
        private Color colorClock;
        private Color colorRedCoincidence;
        private Color colorweaklyPrecedes;
        private Color colorTimerZ;
        private Color colorpacket;
        private int width;

        public ListColor(ColorSelection selc) {
            this.sel = selc;
            if (this.sel != null) {
                this.setcolor();
            }
        }

        public int setcolor() {
            this.colorBack = this.sel.convertColor(0);
            this.colorWhiteRule = this.sel.convertColor(1);
            this.colorWhiteText = this.sel.convertColor(1);
            this.colorClock = this.sel.convertColor(2);
            this.colorYellowZ = this.sel.convertColor(3);
            this.colorTimer = this.sel.convertColor(4);
            this.colorTimertext = this.sel.convertColor(5);
            this.colorTimerZ = this.sel.convertColor(6);
            this.colorGhostClock = this.sel.convertColor(7);
            this.colorRedTime = this.sel.convertColor(8);
            this.colorWhiteArrow = this.sel.convertColor(9);
            this.colorRedCoincidence = this.sel.convertColor(10);
            this.colorweaklyPrecedes = this.sel.convertColor(11);
            this.colorpacket = this.sel.convertColor(12);
            this.width = this.sel.getWidthName();
            return 0;
        }
    }
}

