/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.websocket;

import com.google.inject.Injector;
import java.util.List;
import java.util.ServiceLoader;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.jsr356.server.ContainerDefaultConfigurator;

public class GLSPConfigurator
extends ServerEndpointConfig.Configurator {
    private ServerEndpointConfig.Configurator containerConfigurator;
    private final Injector injector;

    public GLSPConfigurator(Injector injector) {
        this.injector = injector;
    }

    ServerEndpointConfig.Configurator getContainerConfigurator() {
        if (this.containerConfigurator == null) {
            ServiceLoader<ServerEndpointConfig.Configurator> loader = ServiceLoader.load(ServerEndpointConfig.Configurator.class);
            this.containerConfigurator = loader.iterator().hasNext() ? loader.iterator().next() : new ContainerDefaultConfigurator();
        }
        return this.containerConfigurator;
    }

    public String getNegotiatedSubprotocol(List<String> supported, List<String> requested) {
        return this.getContainerConfigurator().getNegotiatedSubprotocol(supported, requested);
    }

    public List<Extension> getNegotiatedExtensions(List<Extension> installed, List<Extension> requested) {
        return this.getContainerConfigurator().getNegotiatedExtensions(installed, requested);
    }

    public boolean checkOrigin(String originHeaderValue) {
        return this.getContainerConfigurator().checkOrigin(originHeaderValue);
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        return (T)this.injector.getInstance(endpointClass);
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
    }
}

