/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.taskedit;

import com.google.inject.Inject;
import org.eclipse.glsp.server.features.directediting.ContextEditValidator;
import org.eclipse.glsp.server.features.directediting.RequestEditValidationAction;
import org.eclipse.glsp.server.features.directediting.ValidationStatus;
import org.eclipse.glsp.server.model.GModelState;

public class TaskEditValidator
implements ContextEditValidator {
    @Inject
    protected GModelState modelState;

    public String getContextId() {
        return "task-editor";
    }

    public ValidationStatus validate(RequestEditValidationAction action) {
        block5: {
            String typeString;
            String text = action.getText();
            if (text.startsWith("duration:")) {
                String durationString = text.substring("duration:".length());
                try {
                    int duration = Integer.parseInt(durationString);
                    if (duration < 0 || duration > 100) {
                        return ValidationStatus.warning((String)("'" + durationString + "' should be between 0 and 100."));
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    return ValidationStatus.error((String)("'" + durationString + "' is not a valid number."));
                }
            }
            if (text.startsWith("type:") && !(typeString = text.substring("type:".length())).equals("automated") && !typeString.equals("manual")) {
                return ValidationStatus.error((String)("Type of task can only be manual or automatic. You entered '" + typeString + "'."));
            }
        }
        return ValidationStatus.ok();
    }
}

