/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.junit.NoJobsWorkspaceTestCase;

public class CoreTextFileBufferProviderTest
extends NoJobsWorkspaceTestCase {
    private Path path = new Path("/foo/.foo");

    public void test1() throws Exception {
        IProject p = this.getProject(this.path.segment(0));
        p.create(null);
        p.open(null);
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forLocation((IPath)this.path, (LocationKind)LocationKind.IFILE, (ITextFileBufferManager)ITextFileBufferManager.DEFAULT);
        this._test(provider);
    }

    public void test2() throws Exception {
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forLocation((IPath)this.path, (LocationKind)LocationKind.LOCATION, (ITextFileBufferManager)ITextFileBufferManager.DEFAULT);
        this._test(provider);
    }

    public void test3() throws Exception {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)this.path);
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forFileStore((IFileStore)fileStore, (ITextFileBufferManager)ITextFileBufferManager.DEFAULT);
        this._test(provider);
    }

    private void _test(ICoreTextFileBufferProvider provider) throws Exception {
        CoreTextFileBufferProviderTest.assertSame((Object)ITextFileBufferManager.DEFAULT, (Object)provider.getBufferManager());
        CoreTextFileBufferProviderTest.assertNull((Object)provider.getBuffer());
        provider.connect(null);
        try {
            CoreTextFileBufferProviderTest.assertNotNull((Object)provider.getBuffer());
        }
        finally {
            provider.disconnect(null);
        }
        CoreTextFileBufferProviderTest.assertNull((Object)provider.getBuffer());
    }
}

