/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.handly.util.ArrayUtil;

public class ArrayUtilTest
extends TestCase {
    public void testContains() {
        Object[] objectArray = new Object[3];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        Object[] a = objectArray;
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.contains((Object[])a, (Object)1));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.contains((Object[])a, (Object)2));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.contains((Object[])a, null));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.contains((Object[])a, (Object)"foo"));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.contains((Object[])a, (Object)"bar"));
    }

    public void testIndexOf() {
        Object[] objectArray = new Object[6];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        objectArray[3] = 1;
        objectArray[5] = "foo";
        Object[] a = objectArray;
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.indexOf((Object[])a, (Object)1));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.indexOf((Object[])a, (Object)2));
        ArrayUtilTest.assertEquals((int)1, (int)ArrayUtil.indexOf((Object[])a, null));
        ArrayUtilTest.assertEquals((int)2, (int)ArrayUtil.indexOf((Object[])a, (Object)"foo"));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.indexOf((Object[])a, (Object)"bar"));
    }

    public void testLastIndexOf() {
        Object[] objectArray = new Object[6];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        objectArray[3] = 1;
        objectArray[5] = "foo";
        Object[] a = objectArray;
        ArrayUtilTest.assertEquals((int)3, (int)ArrayUtil.lastIndexOf((Object[])a, (Object)1));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.lastIndexOf((Object[])a, (Object)2));
        ArrayUtilTest.assertEquals((int)4, (int)ArrayUtil.lastIndexOf((Object[])a, null));
        ArrayUtilTest.assertEquals((int)5, (int)ArrayUtil.lastIndexOf((Object[])a, (Object)"foo"));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.lastIndexOf((Object[])a, (Object)"bar"));
    }

    public void testContainsMatching() {
        Object[] a = new Integer[]{1, 0, 1};
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.containsMatching((Object[])a, e -> e > 0));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.containsMatching((Object[])a, e -> e < 0));
    }

    public void testIndexOfMatching() {
        Object[] a = new Integer[]{1, 0, 1};
        ArrayUtilTest.assertEquals((int)0, (int)ArrayUtil.indexOfMatching((Object[])a, e -> e > 0));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.indexOfMatching((Object[])a, e -> e < 0));
    }

    public void testLastIndexOfMatching() {
        Object[] a = new Integer[]{1, 0, 1};
        ArrayUtilTest.assertEquals((int)2, (int)ArrayUtil.lastIndexOfMatching((Object[])a, e -> e > 0));
        ArrayUtilTest.assertEquals((int)-1, (int)ArrayUtil.lastIndexOfMatching((Object[])a, e -> e < 0));
    }

    public void testCollectMatching() {
        Object[] a = new Integer[]{1, 0, 1};
        ArrayUtilTest.assertEquals(Arrays.asList(1, 1), (Object)ArrayUtil.collectMatching((Object[])a, e -> e > 0, new ArrayList()));
        ArrayUtilTest.assertTrue((boolean)((ArrayList)ArrayUtil.collectMatching((Object[])a, e -> e < 0, new ArrayList())).isEmpty());
    }

    public void testElementsOfType() {
        Object[] objectArray = new Object[5];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        objectArray[3] = 2;
        objectArray[4] = 3;
        Object[] a = objectArray;
        ArrayUtilTest.assertEquals(Arrays.asList(1, 2, 3), (Object)ArrayUtil.elementsOfType((Object[])a, (Class[])new Class[]{Integer.class}));
        ArrayUtilTest.assertEquals(Arrays.asList("foo"), (Object)ArrayUtil.elementsOfType((Object[])a, (Class[])new Class[]{String.class}));
        ArrayUtilTest.assertEquals(Arrays.asList(1, "foo", 2, 3), (Object)ArrayUtil.elementsOfType((Object[])a, (Class[])new Class[]{Integer.class, String.class, Class.class}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.elementsOfType((Object[])a, (Class[])new Class[]{Class.class}).isEmpty());
    }

    public void testHasElementsOfType() {
        Object[] objectArray = new Object[3];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        Object[] a = objectArray;
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.hasElementsOfType((Object[])a, (Class[])new Class[]{Integer.class}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.hasElementsOfType((Object[])a, (Class[])new Class[]{String.class}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.hasElementsOfType((Object[])a, (Class[])new Class[]{Integer.class, String.class, Class.class}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.hasElementsOfType((Object[])a, (Class[])new Class[]{Class.class}));
    }

    public void testHasElementsNotOfType() {
        Object[] a = new Object[]{1, "foo"};
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.hasElementsNotOfType((Object[])a, (Class[])new Class[]{Integer.class}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.hasElementsNotOfType((Object[])a, (Class[])new Class[]{String.class}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.hasElementsNotOfType((Object[])a, (Class[])new Class[]{Integer.class, String.class}));
    }

    public void testOnlyElementsOfType() {
        Object[] a = new Object[]{1, "foo"};
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.hasOnlyElementsOfType((Object[])a, (Class[])new Class[]{Integer.class}));
        ArrayUtilTest.assertFalse((boolean)ArrayUtil.hasOnlyElementsOfType((Object[])a, (Class[])new Class[]{String.class}));
        ArrayUtilTest.assertTrue((boolean)ArrayUtil.hasOnlyElementsOfType((Object[])a, (Class[])new Class[]{Integer.class, String.class}));
    }

    public void testConcat() {
        Object[] objectArray = new Object[4];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        Object[] a = objectArray;
        Integer[] b = new Integer[]{1, 2, 3};
        ArrayUtilTest.assertEquals(Arrays.asList(1, null, "foo", null, 1, 2, 3), (Object)ArrayUtil.concat((Object[])a, Arrays.asList(b)));
    }

    public void testUnion() {
        Object[] objectArray = new Object[4];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        Object[] a = objectArray;
        Integer[] b = new Integer[]{1, 2, 3};
        ArrayUtilTest.assertEquals(Arrays.asList(1, null, "foo", 2, 3), new ArrayList(ArrayUtil.union((Object[])a, Arrays.asList(b))));
    }

    public void testSetMinus() {
        Object[] objectArray = new Object[4];
        objectArray[0] = 1;
        objectArray[2] = "foo";
        Object[] a = objectArray;
        Integer[] b = new Integer[]{1, 2, 3};
        ArrayUtilTest.assertEquals(Arrays.asList(null, "foo"), new ArrayList(ArrayUtil.setMinus((Object[])a, Arrays.asList(b))));
    }
}

