/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.util.Property;

public class Contexts {
    public static final IContext EMPTY_CONTEXT = new EmptyContext();

    public static <T> IContext of(Property<T> property, T value) {
        return new SingletonContext(property, value);
    }

    public static <T> IContext of(Class<T> clazz, T value) {
        return new SingletonContext(clazz, value);
    }

    public static IContext with(IContext ... contexts) {
        return Contexts.with(Arrays.asList(contexts));
    }

    public static IContext with(List<IContext> contexts) {
        return new CompositeContext(Contexts.flatten(contexts));
    }

    private static List<IContext> flatten(List<IContext> contexts) {
        ArrayList<IContext> result = new ArrayList<IContext>();
        for (IContext context : contexts) {
            if (context instanceof CompositeContext) {
                result.addAll(((CompositeContext)context).contexts);
                continue;
            }
            result.add(Objects.requireNonNull(context));
        }
        return result;
    }

    private Contexts() {
    }

    static class CompositeContext
    implements IContext {
        final List<IContext> contexts;

        CompositeContext(List<IContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public <T> T get(Property<T> property) {
            for (IContext context : this.contexts) {
                T value = context.get(property);
                if (value != null) {
                    return value;
                }
                if (!context.containsKey(property)) continue;
                return null;
            }
            return null;
        }

        @Override
        public <T> T getOrDefault(Property<T> property) {
            for (IContext context : this.contexts) {
                T value = context.get(property);
                if (value != null) {
                    return value;
                }
                if (!context.containsKey(property)) continue;
                return null;
            }
            return property.defaultValue();
        }

        @Override
        public <T> T get(Class<T> clazz) {
            for (IContext context : this.contexts) {
                T value = context.get(clazz);
                if (value != null) {
                    return value;
                }
                if (!context.containsKey(clazz)) continue;
                return null;
            }
            return null;
        }

        @Override
        public boolean containsKey(Property<?> property) {
            for (IContext context : this.contexts) {
                if (!context.containsKey(property)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsKey(Class<?> clazz) {
            for (IContext context : this.contexts) {
                if (!context.containsKey(clazz)) continue;
                return true;
            }
            return false;
        }
    }

    private static class EmptyContext
    implements IContext {
        private EmptyContext() {
        }

        @Override
        public <T> T get(Property<T> property) {
            return null;
        }

        @Override
        public <T> T getOrDefault(Property<T> property) {
            return property.defaultValue();
        }

        @Override
        public <T> T get(Class<T> clazz) {
            return null;
        }

        @Override
        public boolean containsKey(Property<?> property) {
            return false;
        }

        @Override
        public boolean containsKey(Class<?> clazz) {
            return false;
        }
    }

    private static class SingletonContext
    implements IContext {
        private final Object key;
        private final Object value;

        private SingletonContext(Object key, Object value) {
            this.key = Objects.requireNonNull(key);
            this.value = value;
        }

        @Override
        public <T> T get(Property<T> property) {
            if (property == this.key) {
                return (T)this.value;
            }
            return null;
        }

        @Override
        public <T> T get(Class<T> clazz) {
            if (clazz == this.key) {
                return (T)this.value;
            }
            return null;
        }

        @Override
        public boolean containsKey(Property<?> property) {
            return property == this.key;
        }

        @Override
        public boolean containsKey(Class<?> clazz) {
            return clazz == this.key;
        }
    }
}

