/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.preference;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.ui.preference.IPreference;
import org.eclipse.handly.ui.preference.IPreferenceListener;
import org.eclipse.handly.ui.preference.PreferenceChangeEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractPreference
implements IPreference {
    private final String name;
    private final IPreferenceStore store;
    private final IPropertyChangeListener storeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(AbstractPreference.this.name)) {
                AbstractPreference.this.fireValueChangedEvent(new PreferenceChangeEvent(AbstractPreference.this, event.getOldValue(), event.getNewValue()));
            }
        }
    };
    private final ListenerList<IPreferenceListener> listeners = new ListenerList();

    public AbstractPreference(String name, IPreferenceStore store) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (store == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.store = store;
    }

    public final String getName() {
        return this.name;
    }

    public final IPreferenceStore getStore() {
        return this.store;
    }

    public final void setToDefault() {
        this.store.setToDefault(this.name);
    }

    public final boolean isDefault() {
        return this.store.isDefault(this.name);
    }

    @Override
    public final synchronized void addListener(IPreferenceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners.isEmpty()) {
            this.store.addPropertyChangeListener(this.storeListener);
        }
        this.listeners.add((Object)listener);
    }

    @Override
    public final synchronized void removeListener(IPreferenceListener listener) {
        this.listeners.remove((Object)listener);
        if (this.listeners.isEmpty()) {
            this.store.removePropertyChangeListener(this.storeListener);
        }
    }

    private void fireValueChangedEvent(PreferenceChangeEvent event) {
        for (IPreferenceListener listener : this.listeners) {
            SafeRunner.run(() -> listener.preferenceChanged(event));
        }
    }
}

