/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.dialogs.about;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.e4.ui.internal.dialogs.about.HyperlinkRange;

public final class HyperlinkExtractor {
    private String aboutProperty;
    private List<HyperlinkRange> linkRanges;
    private List<String> links;

    public HyperlinkExtractor(String aboutProperty) {
        this.aboutProperty = aboutProperty;
        this.linkRanges = new ArrayList<HyperlinkRange>();
        this.links = new ArrayList<String>();
        this.extractLinks();
    }

    private void extractLinks() {
        int urlSeparatorOffset = this.aboutProperty.indexOf("://");
        while (urlSeparatorOffset >= 0) {
            char ch;
            boolean startDoubleQuote = false;
            int urlOffset = urlSeparatorOffset;
            do {
                ch = ' ';
                if (--urlOffset > -1) {
                    ch = this.aboutProperty.charAt(urlOffset);
                }
                boolean bl = startDoubleQuote = ch == '\"';
            } while (Character.isUnicodeIdentifierStart(ch));
            ++urlOffset;
            StringTokenizer tokenizer = new StringTokenizer(this.aboutProperty.substring(urlSeparatorOffset + 3), " \t\n\r\f<>", false);
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            int urlLength = tokenizer.nextToken().length() + 3 + urlSeparatorOffset - urlOffset;
            if (startDoubleQuote) {
                int endOffset = -1;
                int nextDoubleQuote = this.aboutProperty.indexOf(34, urlOffset);
                int nextWhitespace = this.aboutProperty.indexOf(32, urlOffset);
                if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                    endOffset = Math.min(nextDoubleQuote, nextWhitespace);
                } else if (nextDoubleQuote != -1) {
                    endOffset = nextDoubleQuote;
                } else if (nextWhitespace != -1) {
                    endOffset = nextWhitespace;
                }
                if (endOffset != -1) {
                    urlLength = endOffset - urlOffset;
                }
            }
            this.linkRanges.add(new HyperlinkRange(urlOffset, urlLength));
            this.links.add(this.aboutProperty.substring(urlOffset, urlOffset + urlLength));
            urlSeparatorOffset = this.aboutProperty.indexOf("://", urlOffset + urlLength + 1);
        }
    }

    public List<HyperlinkRange> getLinkRanges() {
        return this.linkRanges;
    }

    public List<String> getLinks() {
        return this.links;
    }
}

