/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit.parser.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.parser.utils.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitContentManager<T> {
    private Map<Location, T> contentMap = new TreeMap<Location, T>();

    public void addAllContent(Map<Location, T> content) {
        for (Map.Entry<Location, T> entry : content.entrySet()) {
            this.addContent(entry.getKey(), entry.getValue());
        }
    }

    public void addContent(Location location, T element) {
        ArrayList<Location> toRemove = new ArrayList<Location>();
        for (Location existingLocation : this.contentMap.keySet()) {
            if (existingLocation.contains(location)) {
                return;
            }
            if (!location.contains(existingLocation)) continue;
            toRemove.add(existingLocation);
        }
        for (Location existingLocation : toRemove) {
            this.contentMap.remove(existingLocation);
        }
        this.contentMap.put(location, element);
    }

    public Map<Location, T> getContent() {
        return this.contentMap;
    }

    public void validateContent(String string, int rootOffset) throws ParseException {
        this.validateContent(string, 0, string.length(), rootOffset);
    }

    public void validateContent(String string, int startOffset, int endOffset, int rootOffset) throws ParseException {
        int lastOffset = startOffset;
        for (Location location : this.contentMap.keySet()) {
            if (lastOffset < location.getStartOffset()) {
                this.validateZone(string, lastOffset, location.getStartOffset(), rootOffset);
            }
            lastOffset = location.getEndOffset() + 1;
        }
        if (lastOffset < endOffset) {
            this.validateZone(string, lastOffset, endOffset, rootOffset);
        }
    }

    private void validateZone(String string, int startOffset, int endOffset, int rootOffset) throws ParseException {
        String invalidContent = "<UNDEFINED>";
        try {
            invalidContent = string.substring(startOffset, endOffset);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (!ModelingUnitContentManager.isSpace(invalidContent) && !ModelingUnitContentManager.isComment(invalidContent.trim())) {
            int errorOffset = rootOffset + startOffset + ModelingUnitContentManager.getBeginningSpaceLength(invalidContent);
            int errorLength = invalidContent.trim().length();
            throw new ParseException("Unrecognized content", errorOffset, errorLength);
        }
    }

    private static int getBeginningSpaceLength(String string) {
        Pattern p = Pattern.compile("^\\s+");
        Matcher m = p.matcher(string);
        int index = 0;
        if (m.find()) {
            index = m.group().length();
        }
        return index;
    }

    private static boolean isSpace(String string) {
        return Pattern.matches("\\s+", string);
    }

    private static boolean isComment(String string) {
        boolean res = true;
        String[] lines = string.split("[\n\r]");
        int i = 0;
        while (i < lines.length) {
            res &= Pattern.matches("\\s*//.*", lines[i]) || ModelingUnitContentManager.isSpace(lines[i]);
            ++i;
        }
        return res;
    }
}

