/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.common.query.AbstractIntentQuery;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSubSectionContainer;
import org.eclipse.mylyn.docs.intent.core.genericunit.IntentSectionReferenceInstruction;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentDocumentQuery
extends AbstractIntentQuery {
    private IntentDocument intentDocument;

    public IntentDocumentQuery(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
    }

    public IntentDocument getOrCreateIntentDocument() {
        if (this.intentDocument == null) {
            Resource resource = this.repositoryAdapter.getResource("/INTENT/IntentDocument");
            if (resource.getContents().isEmpty()) {
                resource.getContents().add((Object)IntentDocumentFactory.eINSTANCE.createIntentDocument());
            }
            this.intentDocument = (IntentDocument)resource.getContents().get(0);
        }
        return this.intentDocument;
    }

    public IntentStructuredElement getElementAtLevel(String level) throws NumberFormatException {
        IntentStructuredElement elementAtLevel = null;
        IntentIndexEntry indexEntry = new IndexQuery(this.repositoryAdapter).getIndexEntryAtLevel(level);
        if (indexEntry != null && indexEntry.getReferencedElement() instanceof IntentStructuredElement) {
            elementAtLevel = (IntentStructuredElement)indexEntry.getReferencedElement();
        }
        return elementAtLevel;
    }

    public Collection<IntentSectionReferenceInstruction> getAllIntentReferenceInstructions() {
        LinkedHashSet intentReferences = Sets.newLinkedHashSet();
        for (DescriptionUnit unit : this.getAllDescriptionUnits()) {
            intentReferences.addAll(Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)unit.getInstructions(), IntentSectionReferenceInstruction.class)));
        }
        return intentReferences;
    }

    public Collection<DescriptionUnit> getAllDescriptionUnits() {
        LinkedHashSet descriptionUnits = Sets.newLinkedHashSet();
        for (IntentChapter chapter : this.getOrCreateIntentDocument().getChapters()) {
            descriptionUnits.addAll(this.getAllDescriptionUnits((IntentSubSectionContainer)chapter));
        }
        return descriptionUnits;
    }

    public Collection<DescriptionUnit> getAllDescriptionUnits(IntentSubSectionContainer intentElement) {
        LinkedHashSet descriptionUnits = Sets.newLinkedHashSet();
        descriptionUnits.addAll(intentElement.getDescriptionUnits());
        for (IntentSection subSection : intentElement.getSubSections()) {
            descriptionUnits.addAll(this.getAllDescriptionUnits((IntentSubSectionContainer)subSection));
        }
        return descriptionUnits;
    }
}

