/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.internal.state;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionBloc;
import org.eclipse.mylyn.docs.intent.core.document.descriptionunit.DescriptionUnit;
import org.eclipse.mylyn.docs.intent.markup.markup.Block;
import org.eclipse.mylyn.docs.intent.parser.descriptionunit.DescriptionUnitParser;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentDefaultState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentGenericState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.SSection;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;

public class IntentSubSectionContainerState
extends IntentDefaultState {
    public IntentSubSectionContainerState(int offset, int declarationLength, IntentGenericState previous, EObject currentElement, IntentPositionManager positionManager, String title, String completeLevel) throws ParseException {
        super(offset, declarationLength, previous, currentElement, positionManager);
        this.setTitle(title);
        ((IntentStructuredElement)this.currentElement).setCompleteLevel(completeLevel);
    }

    private void setTitle(String stringTitle) throws ParseException {
        if (stringTitle != null) {
            DescriptionUnit descriptionUnit = new DescriptionUnitParser().parse(stringTitle.trim());
            for (UnitInstruction title : descriptionUnit.getInstructions()) {
                if (!(title instanceof DescriptionBloc)) continue;
                EList contents = ((DescriptionBloc)title).getDescriptionBloc().getContent();
                if (contents.size() != 1) {
                    throw new ParseException("The title of this section isn't well formed", this.fOffset, stringTitle.trim().length());
                }
                Block titleBlock = (Block)contents.get(0);
                ((IntentSection)this.currentElement).setTitle(titleBlock);
            }
        }
    }

    public IntentGenericState beginSection(int offset, int declarationLength, String title) throws ParseException {
        IntentSection subSection = IntentDocumentFactory.eINSTANCE.createIntentSection();
        ((IntentSection)this.currentElement).getIntentContent().add((Object)subSection);
        return new SSection(offset, declarationLength, (IntentGenericState)this, subSection, this.positionManager, title, String.valueOf(((IntentStructuredElement)this.currentElement).getCompleteLevel()) + "." + this.getIndex((IntentStructuredElement)subSection));
    }

    private String getIndex(IntentStructuredElement element) {
        int positionInContainer = 0;
        if (element.eContainer() instanceof IntentDocument) {
            positionInContainer = element.eContainer().eContents().indexOf((Object)element) + 1;
        } else if (element.eContainer() instanceof IntentSection) {
            positionInContainer = ((IntentSection)element.eContainer()).getSubSections().indexOf((Object)element) + 1;
        }
        return Integer.toString(positionInContainer);
    }

    public IntentGenericState descriptionUnitContent(int offset, int length, String descriptionUnitContent) throws ParseException {
        int titleLength = 0;
        String descriptionUnitDescription = descriptionUnitContent;
        if (descriptionUnitDescription.trim().length() > 0) {
            DescriptionUnit descriptionUnit = new DescriptionUnitParser().parse(descriptionUnitDescription);
            ((IntentSection)this.currentElement).getIntentContent().add((Object)descriptionUnit);
            this.positionManager.setPositionForInstruction((EObject)descriptionUnit, offset + titleLength, length - titleLength);
        }
        return this;
    }

    public IntentGenericState endStructuredElement(int offset) {
        this.positionManager.setPositionForInstruction(this.getCurrentElement(), this.getOffset(), offset - this.getOffset(), this.getDeclarationLength());
        return this.previousState();
    }
}

