/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractTemporalAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.TemporalOffset;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldBeInTheFuture;
import org.assertj.core.error.ShouldBeInThePast;
import org.assertj.core.internal.ChronoZonedDateTimeByInstantComparator;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Preconditions;

public abstract class AbstractZonedDateTimeAssert<SELF extends AbstractZonedDateTimeAssert<SELF>>
extends AbstractTemporalAssert<SELF, ZonedDateTime> {
    public static final String NULL_DATE_TIME_PARAMETER_MESSAGE = "The ZonedDateTime to compare actual with should not be null";

    private static void assertDateTimeParameterIsNotNull(ZonedDateTime dateTime) {
        Preconditions.checkArgument(dateTime != null, NULL_DATE_TIME_PARAMETER_MESSAGE, new Object[0]);
    }

    public SELF isBefore(ZonedDateTime other) {
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        this.comparables.assertIsBefore(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBefore(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBefore(this.parse(dateTimeAsString));
    }

    public SELF isBeforeOrEqualTo(ZonedDateTime other) {
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        this.comparables.assertIsBeforeOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBeforeOrEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBeforeOrEqualTo(this.parse(dateTimeAsString));
    }

    public SELF isAfterOrEqualTo(ZonedDateTime other) {
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        this.comparables.assertIsAfterOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isAfterOrEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfterOrEqualTo(this.parse(dateTimeAsString));
    }

    public SELF isAfter(ZonedDateTime other) {
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        this.comparables.assertIsAfter(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isAfter(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfter(this.parse(dateTimeAsString));
    }

    public SELF isEqualToIgnoringNanos(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringNanos((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    @Deprecated
    public SELF isEqualToIgnoringSeconds(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringSeconds((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringMinutes(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringMinutes((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualToIgnoringHours(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.haveSameYearMonthAndDayOfMonth((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, otherInActualTimeZone));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    @Override
    public SELF isEqualTo(Object expected) {
        if (this.actual == null || expected == null) {
            super.isEqualTo(expected);
        } else {
            this.comparables.assertEqual(this.info, this.actual, expected);
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)this.isEqualTo(this.parse(dateTimeAsString));
    }

    @Override
    public SELF isNotEqualTo(Object expected) {
        if (this.actual == null || expected == null) {
            super.isNotEqualTo(expected);
        } else {
            this.comparables.assertNotEqual(this.info, this.actual, expected);
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isNotEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (SELF)this.isNotEqualTo(this.parse(dateTimeAsString));
    }

    public SELF isIn(ZonedDateTime ... expected) {
        return (SELF)((AbstractZonedDateTimeAssert)this.isIn((Object[])this.changeToActualTimeZone(expected)));
    }

    public SELF isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public SELF isNotIn(ZonedDateTime ... expected) {
        return (SELF)((AbstractZonedDateTimeAssert)this.isNotIn((Object[])this.changeToActualTimeZone(expected)));
    }

    public SELF isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isNotIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public SELF isInThePast() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((ZonedDateTime)this.actual).isBefore(ZonedDateTime.now(((ZonedDateTime)this.actual).getZone()))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeInThePast.shouldBeInThePast((Temporal)this.actual));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isInTheFuture() {
        Objects.instance().assertNotNull(this.info, this.actual);
        if (!((ZonedDateTime)this.actual).isAfter(ZonedDateTime.now(((ZonedDateTime)this.actual).getZone()))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeInTheFuture.shouldBeInTheFuture((Temporal)this.actual));
        }
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBetween(ZonedDateTime startInclusive, ZonedDateTime endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        return this.isBetween(this.parse(startInclusive), this.parse(endInclusive));
    }

    public SELF isStrictlyBetween(ZonedDateTime startExclusive, ZonedDateTime endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractZonedDateTimeAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        return this.isStrictlyBetween(this.parse(startExclusive), this.parse(endExclusive));
    }

    @Override
    public SELF isCloseTo(ZonedDateTime other, TemporalOffset<? super ZonedDateTime> offset) {
        return (SELF)((AbstractZonedDateTimeAssert)super.isCloseTo(other, offset));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        AbstractZonedDateTimeAssert self = (AbstractZonedDateTimeAssert)super.usingDefaultComparator();
        self.comparables = this.buildDefaultComparables();
        return (SELF)self;
    }

    private Comparables buildDefaultComparables() {
        ChronoZonedDateTimeByInstantComparator defaultComparator = ChronoZonedDateTimeByInstantComparator.getInstance();
        return new Comparables(new ComparatorBasedComparisonStrategy(defaultComparator, defaultComparator.description()));
    }

    private ZonedDateTime[] convertToDateTimeArray(String ... dateTimesAsString) {
        ZonedDateTime[] dates = new ZonedDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = this.parse(dateTimesAsString[i]);
        }
        return dates;
    }

    private ZonedDateTime[] changeToActualTimeZone(ZonedDateTime ... dateTimes) {
        ZonedDateTime[] dates = new ZonedDateTime[dateTimes.length];
        for (int i = 0; i < dateTimes.length; ++i) {
            dates[i] = this.sameInstantInActualTimeZone(dateTimes[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        Preconditions.checkArgument(values != null, "The given ZonedDateTime array should not be null", new Object[0]);
        Preconditions.checkArgument(values.length > 0, "The given ZonedDateTime array should not be empty", new Object[0]);
    }

    @Override
    protected ZonedDateTime parse(String dateTimeAsString) {
        return ZonedDateTime.parse(dateTimeAsString, DateTimeFormatter.ISO_DATE_TIME);
    }

    private ZonedDateTime sameInstantInActualTimeZone(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        if (this.actual == null) {
            return zonedDateTime;
        }
        return zonedDateTime.withZoneSameInstant(((ZonedDateTime)this.actual).getZone());
    }

    private static void assertDateTimeAsStringParameterIsNotNull(String dateTimeAsString) {
        Preconditions.checkArgument(dateTimeAsString != null, "The String representing the ZonedDateTime to compare actual with should not be null", new Object[0]);
    }

    private static boolean areEqualIgnoringNanos(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(ZonedDateTime actual, ZonedDateTime other) {
        return actual.getYear() == other.getYear();
    }

    protected AbstractZonedDateTimeAssert(ZonedDateTime actual, Class<?> selfType) {
        super(actual, selfType);
        this.comparables = this.buildDefaultComparables();
    }
}

