/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups;

import jakarta.validation.GroupSequence;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.ZipCodeCoherenceChecker;

@GroupSequence(value={Address.class, HighLevelCoherence.class})
@ZipCodeCoherenceChecker(groups={HighLevelCoherence.class})
public class Address {
    @NotNull(groups={Default.class})
    @Size(max=50, message="Street names cannot have more than {max} characters.")
    private @NotNull(groups={Default.class}) @Size(max=50, message="Street names cannot have more than {max} characters.") String street;
    @NotNull(groups={Default.class}, message="Zipcode may not be null")
    @Size(max=5, message="Zipcode cannot have more than {max} characters.")
    private @NotNull(groups={Default.class}, message="Zipcode may not be null") @Size(max=5, message="Zipcode cannot have more than {max} characters.") String zipcode;
    @NotNull(groups={Default.class})
    @Size(max=30, message="City cannot have more than {max} characters.")
    private @NotNull(groups={Default.class}) @Size(max=30, message="City cannot have more than {max} characters.") String city;

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @GroupSequence(value={Default.class, HighLevelCoherence.class})
    public static interface Complete {
    }

    public static interface HighLevelCoherence {
    }
}

