/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.RandomTestFinder;
import com.sun.javatest.finder.ReverseTestFinder;
import com.sun.javatest.tool.Preferences;
import java.io.File;
import java.util.Comparator;
import java.util.Optional;

public class TestFinderDecorator
extends TestFinder {
    private TestFinder origTestFinder;
    private TestFinder currentTestFinder;

    public TestFinderDecorator(TestFinder testFinder) {
        this.origTestFinder = testFinder;
        this.setCurrentTestFinder();
        Preferences.access().addObserver("javatest.executionOrder", (name, newValue) -> this.setCurrentTestFinder());
    }

    private void setCurrentTestFinder() {
        String value = Preferences.access().getPreference("javatest.executionOrder");
        String sysValue = System.getProperties().getProperty("javatest.executionOrder");
        if (sysValue != null && !sysValue.isEmpty()) {
            value = sysValue;
        }
        this.currentTestFinder = "reverse".equals(value) ? new ReverseTestFinder(this.origTestFinder) : ("random".equals(value) ? new RandomTestFinder(this.origTestFinder) : this.origTestFinder);
    }

    @Override
    public File getRoot() {
        return this.currentTestFinder.getRoot();
    }

    @Override
    public File getRootDir() {
        return this.currentTestFinder.getRootDir();
    }

    @Override
    public void read(File file) {
        this.currentTestFinder.read(file);
    }

    @Override
    public TestDescription[] getTests() {
        return this.currentTestFinder.getTests();
    }

    @Override
    public File[] getFiles() {
        return this.currentTestFinder.getFiles();
    }

    @Override
    public Comparator<String> getComparator() {
        return this.currentTestFinder.getComparator();
    }

    @Override
    public void setComparator(Comparator<String> c) {
        this.currentTestFinder.setComparator(c);
    }

    public TestFinder getCurrentTestFinder() {
        return this.currentTestFinder;
    }

    @Override
    public long lastModified(File f) {
        return this.currentTestFinder.lastModified(f);
    }

    @Override
    public boolean isFolder(File path) {
        return this.currentTestFinder.isFolder(path);
    }

    @Override
    public Optional<Integer> totalNumberOfTestsInTheSuite() {
        return this.currentTestFinder.totalNumberOfTestsInTheSuite();
    }

    @Override
    protected void scan(File file) {
        throw new Error("should not be called!");
    }
}

