/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.httpd.JThttpProvider;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.httpd.ProviderRegistry;
import com.sun.javatest.httpd.httpURL;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;

public class RootRegistry
extends ProviderRegistry {
    protected static final Map<Object, JThttpProvider> obj2prov = new Hashtable<Object, JThttpProvider>();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(RootRegistry.class);
    private static RootRegistry myInstance = new RootRegistry();
    private SpecialURLHandler httpHandle = new SpecialURLHandler();

    private RootRegistry() {
        this.addHandler("/version", "Version information handler", this.httpHandle);
    }

    public static RootRegistry getInstance() {
        if (myInstance == null) {
            myInstance = new RootRegistry();
        }
        return myInstance;
    }

    public static JThttpProvider getObjectHandler(Object what) {
        return obj2prov.get(what);
    }

    public static void associateObject(Object what, JThttpProvider prov) {
        if (what != null && prov != null) {
            obj2prov.put(what, prov);
        }
    }

    public static void unassociateObject(Object what, JThttpProvider prov) {
        if (what != null && prov != null) {
            JThttpProvider found = obj2prov.get(what);
            if (found == prov) {
                obj2prov.remove(what);
            } else {
                throw new IllegalArgumentException("RR-Unable to unassociateObject, providers do not match.");
            }
        }
    }

    @Override
    public void addHandler(String url, String descrip, JThttpProvider obj) {
        if (!url.equals("/")) {
            super.addHandler(url, descrip, obj);
        } else {
            if (debug) {
                System.out.println("RPR-Adding Handler: " + descrip);
                System.out.println("   RPR-Adding URL: " + url);
                System.out.println("   RPR-Adding OBJ: " + obj);
            }
            String[] path = new String[]{url};
            this.insertHandler(path, descrip, obj, false);
        }
    }

    static {
        String title = i18n.getString("root.name");
        myInstance.addHandler("/", title, new ProviderRegistry.IndexHandler(RootRegistry.myInstance.url2prov));
        myInstance.addHandler("/index.html", title, new ProviderRegistry.IndexHandler(RootRegistry.myInstance.url2prov));
    }

    private static class SpecialURLHandler
    extends JThttpProvider {
        private SpecialURLHandler() {
        }

        @Override
        public void serviceRequest(httpURL url, PrintWriter out) {
            url.resetIterator();
            String target = url.getNextFile();
            if (target.equals("version")) {
                this.printVersionInfo(out);
            }
            out.close();
        }

        private void printVersionInfo(PrintWriter out) {
            SpecialURLHandler.println(out, PageGenerator.getSWName() + " " + PageGenerator.getSWVersion());
            SpecialURLHandler.print(out, i18n.getString("root.built.txt"));
            SpecialURLHandler.println(out, PageGenerator.getSWBuildDate());
        }
    }
}

