/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.lib.Deprecated;
import com.sun.javatest.lib.MultiStatus;
import com.sun.javatest.util.WriterStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultiTest
implements Test {
    protected final Class<?> testClass = this.getClass();
    protected static final Class<?>[] testArgTypes = new Class[0];
    protected PrintWriter log;
    protected PrintWriter ref;
    protected Method[] testMethods = null;
    private String testcaseOrder;
    protected String[] testCases = null;
    protected Vector<String> excludeTestCases = new Vector();
    private boolean testNotApplicable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Status run(String[] argv, PrintStream log, PrintStream ref) {
        PrintWriter pwLog = new PrintWriter(new OutputStreamWriter((OutputStream)log, StandardCharsets.UTF_8));
        PrintWriter pwRef = new PrintWriter(new OutputStreamWriter((OutputStream)ref, StandardCharsets.UTF_8));
        try {
            Status status = this.run(argv, pwLog, pwRef);
            return status;
        }
        finally {
            pwLog.flush();
            pwRef.flush();
        }
    }

    @Override
    public Status run(String[] argv, PrintWriter log, PrintWriter ref) {
        MultiStatus ms = new MultiStatus(log);
        this.ref = ref;
        this.log = log;
        Status initStatus = this.init(argv);
        if (this.testNotApplicable || initStatus != null && initStatus.getType() != 0) {
            return initStatus;
        }
        if (this.testMethods == null) {
            return Status.failed("No test cases supplied");
        }
        for (int i = 0; i < this.testMethods.length; ++i) {
            Status status = null;
            if (this.testMethods[i] == null) {
                status = Status.failed("Test method is null for test case # " + i);
            } else {
                try {
                    Method m = this.testMethods[i];
                    if (this.excludeTestCases.contains(m.getName())) continue;
                    status = this.invokeTestCase(this.testMethods[i]);
                }
                catch (IllegalAccessException e) {
                    status = Status.failed("Could not execute test case: " + this.testMethods[i]);
                }
                catch (InvocationTargetException e) {
                    this.printStackTrace(e.getTargetException());
                    status = Status.failed("Test case throws exception: " + e.getTargetException().toString());
                }
                catch (RuntimeException e) {
                    this.printStackTrace(e);
                    status = Status.failed("Could not access the test case: " + e.toString());
                }
                catch (ThreadDeath t) {
                    this.printStackTrace(t);
                    throw t;
                }
                catch (Throwable t) {
                    this.printStackTrace(t);
                    status = Status.failed("Unexpected Throwable: " + t);
                }
            }
            ms.add(this.testMethods[i].getName(), status);
        }
        return ms.getStatus();
    }

    protected final void decodeAllArgs(String[] argv) throws SetupException {
        int elementsConsumed;
        for (int i = 0; i < argv.length; i += elementsConsumed) {
            elementsConsumed = this.decodeArg(argv, i);
            if (elementsConsumed != 0) continue;
            throw new SetupException("Could not recognize argument: " + argv[i]);
        }
    }

    protected int decodeArg(String[] argv, int index) throws SetupException {
        if (argv[index].equals("-exclude")) {
            this.split(argv[index + 1], this.excludeTestCases);
            return 2;
        }
        if (argv[index].equals("-autoFlush")) {
            this.ref = new PrintWriter((Writer)this.ref, true);
            this.log = new PrintWriter((Writer)this.ref, true);
            return 1;
        }
        if (!argv[index].equals("-TestCaseID")) {
            return 0;
        }
        int i = index + 1;
        if (i < argv.length && argv[i].equals("ALL")) {
            this.getAllTestCases();
            return 2;
        }
        Vector<Method> tests = new Vector<Method>();
        while (i < argv.length && !argv[i].startsWith("-")) {
            tests.addElement(this.getTestCase(argv[i++]));
        }
        if (tests.size() <= 0) {
            throw new SetupException("No test case(s) specified");
        }
        this.testMethods = new Method[tests.size()];
        tests.copyInto(this.testMethods);
        return i - index;
    }

    private void printStackTrace(Throwable t) {
        PrintStream ps = Deprecated.createPrintStream(new WriterStream(this.log));
        t.printStackTrace(ps);
        ps.close();
    }

    private void split(String s, Vector<String> v) {
        int start = 0;
        int i = s.indexOf(44);
        while (i != -1) {
            v.addElement(s.substring(start, i));
            start = i + 1;
            i = s.indexOf(44, start);
        }
        if (start != s.length()) {
            v.addElement(s.substring(start));
        }
    }

    protected void init() throws SetupException {
    }

    protected Method getTestCase(String testCase) throws SetupException {
        try {
            Method test = this.testClass.getMethod(testCase, testArgTypes);
            if (!Status.class.isAssignableFrom(test.getReturnType())) {
                throw new SetupException("Method for test case '" + testCase + "' has wrong return type");
            }
            return test;
        }
        catch (NoSuchMethodException e) {
            throw new SetupException("Could not find test case: " + testCase);
        }
        catch (SecurityException e) {
            throw new SetupException("Failed during setup: " + e.toString());
        }
    }

    protected Status invokeTestCase(Method m) throws IllegalAccessException, InvocationTargetException {
        Object[] testArgs = new Object[]{};
        return (Status)m.invoke((Object)this, testArgs);
    }

    protected void getAllTestCases() throws SetupException {
        Vector<Method> tests = new Vector<Method>();
        Vector<Method> sortedTests = new Vector<Method>();
        Vector<Object> reversed = new Vector();
        try {
            Method[] methods = this.testClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramTypes = methods[i].getParameterTypes();
                Class<?> returnType = methods[i].getReturnType();
                if (paramTypes.length != 0 || !Status.class.isAssignableFrom(returnType)) continue;
                tests.addElement(methods[i]);
            }
            try {
                this.testcaseOrder = System.getProperty("multitest.testcaseOrder");
            }
            catch (SecurityException e) {
                this.log.println("Cannot read system property 'multitest.testcaseOrder': " + e);
            }
            if (tests.size() > 0 && this.testcaseOrder != null && (this.testcaseOrder.equals("sorted") || this.testcaseOrder.equals("reverseSorted"))) {
                Object[] methodNameArray = new Object[tests.size()];
                Hashtable<String, Method> ht = new Hashtable<String, Method>();
                Enumeration e = tests.elements();
                while (e.hasMoreElements()) {
                    Method m = (Method)e.nextElement();
                    ht.put(m.getName(), m);
                }
                int j = 0;
                Enumeration e2 = tests.elements();
                while (e2.hasMoreElements()) {
                    methodNameArray[j] = ((Method)e2.nextElement()).getName();
                    ++j;
                }
                Arrays.sort(methodNameArray);
                for (int i = 0; i < methodNameArray.length; ++i) {
                    sortedTests.addElement((Method)ht.get(methodNameArray[i]));
                }
                if (this.testcaseOrder.equals("reverseSorted")) {
                    reversed = this.reverse(sortedTests);
                    sortedTests = reversed;
                }
            }
        }
        catch (SecurityException e) {
            throw new SetupException("Failed during setup: " + e.toString());
        }
        if (tests.size() <= 0) {
            throw new SetupException("No methods match signature: \"public Status methodName()\"");
        }
        this.testMethods = new Method[tests.size()];
        if (this.testcaseOrder != null && (this.testcaseOrder.equals("sorted") || this.testcaseOrder.equals("reverseSorted"))) {
            sortedTests.copyInto(this.testMethods);
        } else {
            tests.copyInto(this.testMethods);
        }
    }

    public Vector<Method> reverse(Vector<Method> v) {
        Vector<Method> reversed = new Vector<Method>();
        for (int i = v.size() - 1; i >= 0; --i) {
            reversed.addElement(v.elementAt(i));
        }
        return reversed;
    }

    protected Status init(String[] argv) {
        try {
            this.decodeAllArgs(argv);
            if (this.testMethods == null) {
                this.getAllTestCases();
            }
            this.init();
            return null;
        }
        catch (SetupException e) {
            this.testNotApplicable = true;
            return e.isPassed() ? Status.passed(e.getMessage()) : Status.failed(e.getMessage());
        }
    }

    public static class SetupException
    extends Exception {
        private boolean passed = false;

        public SetupException(String s) {
            super(s);
        }

        public static SetupException notApplicable(String msg) {
            SetupException e = new SetupException("Test not applicable: " + msg);
            e.passed = true;
            return e;
        }

        public boolean isPassed() {
            return this.passed;
        }
    }
}

