/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.junit.Assert;
import org.junit.Test;

public class DatasetFactoryTest {
    @Test
    public void testZeros() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[0]);
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[]{3});
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{3});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[]{0, 0});
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{0, 0});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[]{3, 4, 5});
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{3, 4, 5});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testZerosElemental() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[0]);
        act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[]{3});
        act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, (int[])new int[]{3});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new int[]{3, 4, 5});
        act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, (int[])new int[]{3, 4, 5});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testZerosCompound() {
        CompoundDoubleDataset exp = new CompoundDoubleDataset();
        CompoundDoubleDataset act = (CompoundDoubleDataset)DatasetFactory.zeros((int)0, CompoundDoubleDataset.class, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1);
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2);
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1, new int[]{3});
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, (int[])new int[]{3});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2, new int[]{3});
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, (int[])new int[]{3});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1, new int[]{3, 4, 5});
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, (int[])new int[]{3, 4, 5});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2, new int[]{3, 4, 5});
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, (int[])new int[]{3, 4, 5});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testCreator() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, null);
        Assert.assertEquals((Object)exp, (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], null);
        Assert.assertEquals((Object)exp, (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, null, (int[])new int[]{0});
        Assert.assertEquals((Object)exp.reshape(new int[]{0}), (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], (int[])new int[]{0});
        Assert.assertEquals((Object)exp.reshape(new int[]{0}), (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], (int[])new int[]{0, 0, 0});
        Assert.assertEquals((Object)exp.reshape(new int[]{0, 0, 0}), (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], (int[])new int[]{0, 1, 0});
        Assert.assertEquals((Object)exp.reshape(new int[]{0, 1, 0}), (Object)act);
        exp = new DoubleDataset(new double[]{3.0}, new int[0]);
        exp.setShape(new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)3);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0}, new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{2, 3});
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{2, 3});
        Assert.assertEquals((Object)exp, (Object)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[][]{{3.0, 4.0, 5.0}, {6.0, 7.0, 8.0}});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testCreatorInteger() {
        IntegerDataset exp = new IntegerDataset();
        IntegerDataset act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[0], null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new IntegerDataset(new int[]{3}, null);
        exp.setShape(new int[0]);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)3);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new IntegerDataset(new int[]{3, 4, 5}, null);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{3, 4, 5}, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new IntegerDataset(new int[]{3, 4, 5, 6, 7, 8}, new int[]{2, 3});
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{3, 4, 5, 6, 7, 8}, (int[])new int[]{2, 3});
        Assert.assertEquals((Object)exp, (Object)act);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[][]{{3, 4, 5}, {6, 7, 8}});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testCreatorElemental() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new double[]{3.0}, new int[0]);
        exp.setShape(new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, (Object)3, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0}, new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{2, 3});
        act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{2, 3});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testCreatorCompound() {
        CompoundDoubleDataset exp = new CompoundDoubleDataset();
        CompoundDoubleDataset act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)0, CompoundDoubleDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1, new double[]{3.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, (Object)new double[]{3.0}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2, new double[]{3.0, 4.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1, new double[]{3.0, 4.0, 5.0, 6.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2, new double[]{3.0, 4.0, 5.0, 6.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(1, new double[]{3.0, 5.0, 7.0}, new int[]{3, 1});
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, (Object)new double[]{3.0, 5.0, 7.0}, (int[])new int[]{3, 1});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new CompoundDoubleDataset(2, new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{3, 1});
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{3, 1});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testRGBCreator() {
        RGBDataset exp = new RGBDataset();
        RGBDataset act = (RGBDataset)DatasetFactory.createFromObject((int)0, RGBDataset.class, null, null);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new RGBDataset(new short[]{3, 4, 5}, new int[0]);
        act = (RGBDataset)DatasetFactory.createFromObject((int)2, RGBDataset.class, (Object)new short[]{3, 4, 5}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new RGBDataset(new short[]{3, 4, 5, 6, 7, 8}, new int[0]);
        act = (RGBDataset)DatasetFactory.createFromObject((int)2, RGBDataset.class, (Object)new short[]{3, 4, 5, 6, 7, 8}, (int[])new int[0]);
        Assert.assertEquals((Object)exp, (Object)act);
        short[] sArray = new short[9];
        sArray[0] = 3;
        sArray[1] = 4;
        sArray[2] = 5;
        sArray[3] = 6;
        sArray[4] = 7;
        sArray[5] = 8;
        sArray[6] = 9;
        sArray[8] = 1;
        exp = new RGBDataset(sArray, new int[]{3, 1});
        short[] sArray2 = new short[9];
        sArray2[0] = 3;
        sArray2[1] = 4;
        sArray2[2] = 5;
        sArray2[3] = 6;
        sArray2[4] = 7;
        sArray2[5] = 8;
        sArray2[6] = 9;
        sArray2[8] = 1;
        act = (RGBDataset)DatasetFactory.createFromObject((int)2, RGBDataset.class, (Object)sArray2, (int[])new int[]{3, 1});
        Assert.assertEquals((Object)exp, (Object)act);
        exp = new RGBDataset(new short[]{3, 4, 5, 6, 7, 8}, new int[0]);
        act = (RGBDataset)DatasetFactory.createFromObject(RGBDataset.class, (Object)new short[]{3, 4, 5, 6, 7, 8});
        Assert.assertEquals((Object)exp, (Object)act);
    }

    @Test
    public void testLinearSpace() {
        DoubleDataset act = (DoubleDataset)DatasetFactory.createLinearSpace(DoubleDataset.class, (double)2.0, (double)12.4, (int)4);
        Dataset exp = DatasetFactory.createFromObject((Object)new double[]{2.0, 5.466666666666667, 8.933333333333334, 12.4});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createLinearSpace(DoubleDataset.class, (double)12.4, (double)2.0, (int)4);
        exp = DatasetFactory.createFromObject((Object)new double[]{12.4, 8.933333333333334, 5.466666666666667, 2.0});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testLogSpace() {
        DoubleDataset act = (DoubleDataset)DatasetFactory.createLogSpace(DoubleDataset.class, (double)2.0, (double)3.6, (int)4, (double)3.5);
        Dataset exp = DatasetFactory.createFromObject((Object)new double[]{12.25, 23.89492724, 46.60959572, 90.91697129});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act, (double)1.0E-9, (double)1.0E-9);
        act = (DoubleDataset)DatasetFactory.createLogSpace(DoubleDataset.class, (double)3.6, (double)2.0, (int)4, (double)3.5);
        exp = DatasetFactory.createFromObject((Object)new double[]{90.91697129, 46.60959572, 23.89492724, 12.25});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act, (double)1.0E-9, (double)1.0E-9);
    }
}

