/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.List;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;

public class BroadcastSingleIterator
extends BroadcastSelfIterator {
    private int[] bShape;
    private int[] aStride;
    private int[] bStride;
    private final int endrank;
    private final int[] aDelta;
    private final int[] bDelta;
    private final int aStep;
    private final int bStep;
    private int aMax;
    private int bMax;
    private int aStart;
    private int bStart;

    public BroadcastSingleIterator(Dataset a, Dataset b) {
        super(a, b);
        int[] aShape = a.getShapeRef();
        this.maxShape = aShape;
        List<int[]> fullShapes = BroadcastUtils.broadcastShapesToMax(this.maxShape, new int[][]{b.getShapeRef()});
        this.bShape = fullShapes.remove(0);
        int rank = this.maxShape.length;
        this.endrank = rank - 1;
        this.bDataset = b.reshape(this.bShape);
        int[] aOffset = new int[1];
        this.aStride = AbstractDataset.createStrides(this.aDataset, aOffset);
        this.bStride = BroadcastUtils.createBroadcastStrides(this.bDataset, this.maxShape);
        this.pos = new int[rank];
        this.aDelta = new int[rank];
        this.aStep = this.aDataset.getElementsPerItem();
        this.bDelta = new int[rank];
        this.bStep = this.bDataset.getElementsPerItem();
        int j = this.endrank;
        while (j >= 0) {
            this.aDelta[j] = this.aStride[j] * aShape[j];
            this.bDelta[j] = this.bStride[j] * this.bShape[j];
            --j;
        }
        this.aStart = aOffset[0];
        this.bStart = this.bDataset.getOffset();
        this.aMax = this.endrank < 0 ? this.aStep + this.aStart : Integer.MIN_VALUE;
        this.bMax = this.endrank < 0 ? this.bStep + this.bStart : Integer.MIN_VALUE;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        int oldB = this.bIndex;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + 1;
            this.aIndex += this.aStride[j];
            this.bIndex += this.bStride[j];
            if (this.pos[j] < this.maxShape[j]) break;
            this.pos[j] = 0;
            this.aIndex -= this.aDelta[j];
            this.bIndex -= this.bDelta[j];
            --j;
        }
        if (j == -1) {
            if (this.endrank >= 0) {
                return false;
            }
            this.aIndex += this.aStep;
            this.bIndex += this.bStep;
        }
        if (this.aIndex == this.aMax || this.bIndex == this.bMax) {
            return false;
        }
        if (this.read && oldB != this.bIndex) {
            if (this.asDouble) {
                this.bDouble = this.bDataset.getElementDoubleAbs(this.bIndex);
            } else {
                this.bLong = this.bDataset.getElementLongAbs(this.bIndex);
            }
        }
        return true;
    }

    public int[] getFirstShape() {
        return this.maxShape;
    }

    public int[] getSecondShape() {
        return this.bShape;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i <= this.endrank) {
            this.pos[i] = 0;
            ++i;
        }
        if (this.endrank >= 0) {
            this.pos[this.endrank] = -1;
            this.aIndex = this.aStart - this.aStride[this.endrank];
            this.bIndex = this.bStart - this.bStride[this.endrank];
        } else {
            this.aIndex = this.aStart - this.aStep;
            this.bIndex = this.bStart - this.bStep;
        }
        if ((this.aIndex == 0 || this.bIndex == 0 || this.endrank >= 0 && this.bStride[this.endrank] == 0) && this.read) {
            this.storeCurrentValues();
        }
    }
}

