/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FloatDataset
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final Logger logger = LoggerFactory.getLogger(FloatDataset.class);
    protected float[] data;

    @Override
    protected void setData() {
        this.data = (float[])this.odata;
    }

    protected static float[] createArray(int size) {
        float[] array = null;
        try {
            array = new float[size];
        }
        catch (OutOfMemoryError e) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)size);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return array;
    }

    FloatDataset() {
    }

    FloatDataset(int ... shape) {
        if (shape != null) {
            this.size = ShapeUtils.calcSize(shape);
            this.shape = (int[])shape.clone();
            try {
                this.data = FloatDataset.createArray(this.size);
                this.odata = this.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    FloatDataset(float[] data, int ... shape) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        if (shape == null || shape.length == 0) {
            shape = new int[]{data.length};
        }
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != data.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), data.length));
        }
        this.shape = this.size == 0 ? null : (int[])shape.clone();
        this.data = data;
        this.odata = data;
    }

    FloatDataset(FloatDataset dataset) {
        FloatDataset.copyToView(dataset, this, true, true);
        try {
            if (dataset.stride == null) {
                if (dataset.data != null) {
                    this.data = (float[])dataset.data.clone();
                    this.odata = this.data;
                }
            } else {
                this.offset = 0;
                this.stride = null;
                this.base = null;
                this.data = FloatDataset.createArray(this.size);
                this.odata = this.data;
                IndexIterator iter = dataset.getIterator();
                int i = 0;
                while (iter.hasNext()) {
                    this.data[i] = dataset.data[iter.index];
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
    }

    FloatDataset(Dataset dataset) {
        FloatDataset.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        try {
            this.data = FloatDataset.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.data[i] = (float)dataset.getElementDoubleAbs(iter.index);
            ++i;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            if (this.getRank() == 0) {
                return obj.equals(this.getObjectAbs(this.offset));
            }
            return false;
        }
        FloatDataset other = (FloatDataset)obj;
        if (this.size != other.size) {
            return false;
        }
        if (!Arrays.equals(this.shape, other.shape)) {
            return false;
        }
        if (this.data == other.data && this.stride == null && other.stride == null) {
            return true;
        }
        IndexIterator iter = this.getIterator();
        IndexIterator oiter = other.getIterator();
        while (iter.hasNext() && oiter.hasNext()) {
            if (this.data[iter.index] == other.data[oiter.index]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public FloatDataset clone() {
        return new FloatDataset(this);
    }

    static FloatDataset createFromObject(Object obj) {
        FloatDataset result = new FloatDataset();
        if (obj != null) {
            result.shape = ShapeUtils.getShapeFromObject(obj);
            result.size = ShapeUtils.calcSize(result.shape);
            try {
                result.data = FloatDataset.createArray(result.size);
                result.odata = result.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(result.shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
            int[] pos = new int[result.shape.length];
            result.fillData(obj, 0, pos);
        }
        return result;
    }

    static FloatDataset createRange(double stop) {
        return FloatDataset.createRange(0.0, stop, 1.0);
    }

    static FloatDataset createRange(double start, double stop, double step) {
        int size = FloatDataset.calcSteps(start, stop, step);
        FloatDataset result = new FloatDataset(size);
        int i = 0;
        while (i < size) {
            result.data[i] = (float)(start + (double)i * step);
            ++i;
        }
        return result;
    }

    static FloatDataset ones(int ... shape) {
        return new FloatDataset(shape).fill(1);
    }

    @Override
    public FloatDataset fill(Object obj) {
        this.setDirty();
        float dv = (float)DTypeUtils.toReal(obj);
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            this.data[iter.index] = dv;
        }
        return this;
    }

    public float[] getData() {
        return this.data;
    }

    @Override
    protected int getBufferLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public FloatDataset getView(boolean deepCopyMetadata) {
        FloatDataset view = new FloatDataset();
        FloatDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public float getAbs(int index) {
        return this.data[index];
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        return this.data[index] != 0.0f;
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return this.data[index];
    }

    @Override
    public long getElementLongAbs(int index) {
        return DTypeUtils.toLong(this.data[index]);
    }

    @Override
    public Object getObjectAbs(int index) {
        return Float.valueOf(this.data[index]);
    }

    @Override
    public String getStringAbs(int index) {
        return this.stringFormat == null ? String.format("%.8g", Float.valueOf(this.data[index])) : this.stringFormat.format(Float.valueOf(this.data[index]));
    }

    public void setAbs(int index, float val) {
        this.setDirty();
        this.data[index] = val;
    }

    @Override
    protected void setItemDirect(int dindex, int sindex, Object src) {
        this.setDirty();
        float[] dsrc = (float[])src;
        this.data[dindex] = dsrc[sindex];
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(index, (float)DTypeUtils.toReal(obj));
    }

    public float get() {
        return this.data[this.getFirst1DIndex()];
    }

    public float get(int i) {
        return this.data[this.get1DIndex(i)];
    }

    public float get(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    public float get(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.get());
    }

    @Override
    public Object getObject(int i) {
        return Float.valueOf(this.get(i));
    }

    @Override
    public Object getObject(int i, int j) {
        return Float.valueOf(this.get(i, j));
    }

    @Override
    public Object getObject(int ... pos) {
        return Float.valueOf(this.get(pos));
    }

    @Override
    public String getString() {
        return this.getStringAbs(this.getFirst1DIndex());
    }

    @Override
    public String getString(int i) {
        return this.getStringAbs(this.get1DIndex(i));
    }

    @Override
    public String getString(int i, int j) {
        return this.getStringAbs(this.get1DIndex(i, j));
    }

    @Override
    public String getString(int ... pos) {
        return this.getStringAbs(this.get1DIndex(pos));
    }

    @Override
    public double getDouble() {
        return this.get();
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public double getDouble(int ... pos) {
        return this.get(pos);
    }

    @Override
    public float getFloat() {
        return this.get();
    }

    @Override
    public float getFloat(int i) {
        return this.get(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public float getFloat(int ... pos) {
        return this.get(pos);
    }

    @Override
    public long getLong() {
        return (long)this.get();
    }

    @Override
    public long getLong(int i) {
        return (long)this.get(i);
    }

    @Override
    public long getLong(int i, int j) {
        return (long)this.get(i, j);
    }

    @Override
    public long getLong(int ... pos) {
        return (long)this.get(pos);
    }

    @Override
    public int getInt() {
        return (int)this.get();
    }

    @Override
    public int getInt(int i) {
        return (int)this.get(i);
    }

    @Override
    public int getInt(int i, int j) {
        return (int)this.get(i, j);
    }

    @Override
    public int getInt(int ... pos) {
        return (int)this.get(pos);
    }

    @Override
    public short getShort() {
        return (short)this.get();
    }

    @Override
    public short getShort(int i) {
        return (short)this.get(i);
    }

    @Override
    public short getShort(int i, int j) {
        return (short)this.get(i, j);
    }

    @Override
    public short getShort(int ... pos) {
        return (short)this.get(pos);
    }

    @Override
    public byte getByte() {
        return (byte)this.get();
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.get(i);
    }

    @Override
    public byte getByte(int i, int j) {
        return (byte)this.get(i, j);
    }

    @Override
    public byte getByte(int ... pos) {
        return (byte)this.get(pos);
    }

    @Override
    public boolean getBoolean() {
        return this.get() != 0.0f;
    }

    @Override
    public boolean getBoolean(int i) {
        return this.get(i) != 0.0f;
    }

    @Override
    public boolean getBoolean(int i, int j) {
        return this.get(i, j) != 0.0f;
    }

    @Override
    public boolean getBoolean(int ... pos) {
        return this.get(pos) != 0.0f;
    }

    public void setItem(float value) {
        this.setAbs(this.getFirst1DIndex(), value);
    }

    public void setItem(float value, int i) {
        this.setAbs(this.get1DIndex(i), value);
    }

    public void setItem(float value, int i, int j) {
        this.setAbs(this.get1DIndex(i, j), value);
    }

    public void setItem(float value, int ... pos) {
        this.setAbs(this.get1DIndex(pos), value);
    }

    @Override
    public void set(Object obj) {
        this.setItem((float)DTypeUtils.toReal(obj));
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem((float)DTypeUtils.toReal(obj), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem((float)DTypeUtils.toReal(obj), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem((float)DTypeUtils.toReal(obj), pos);
    }

    @Override
    public void resize(int ... newShape) {
        float[] ndata;
        this.setDirty();
        IndexIterator iter = this.getIterator();
        int nsize = ShapeUtils.calcSize(newShape);
        try {
            ndata = FloatDataset.createArray(nsize);
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        while (iter.hasNext() && i < nsize) {
            ndata[i] = this.data[iter.index];
            ++i;
        }
        this.data = ndata;
        this.odata = ndata;
        this.size = nsize;
        this.shape = newShape;
        this.stride = null;
        this.offset = 0;
        this.base = null;
    }

    @Override
    public FloatDataset sort(Integer axis) {
        this.setDirty();
        if (axis == null) {
            if (this.stride == null) {
                Arrays.sort(this.data);
            } else {
                FloatDataset ads = this.clone().sort(null);
                this.setSlicedView(this.getView(false), ads);
            }
        } else {
            axis = this.checkAxis(axis);
            FloatDataset ads = new FloatDataset(this.shape[axis]);
            PositionIterator pi = this.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                this.copyItemsFromAxes(pos, hit, ads);
                Arrays.sort(ads.data);
                this.setItemsOnAxes(pos, hit, ads.data);
            }
        }
        return this;
    }

    @Override
    public FloatDataset getUniqueItems() {
        TreeSet<Float> set = new TreeSet<Float>();
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            set.add(Float.valueOf(this.data[it.index]));
        }
        FloatDataset u = new FloatDataset(set.size());
        int i = 0;
        float[] udata = u.getData();
        for (Float v : set) {
            udata[i++] = v.floatValue();
        }
        return u;
    }

    @Override
    public FloatDataset getSlice(SliceIterator siter) {
        FloatDataset result = new FloatDataset(siter.getShape());
        float[] rdata = result.data;
        int i = 0;
        while (siter.hasNext()) {
            rdata[i] = this.data[siter.index];
            ++i;
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    @Override
    public void fillDataset(Dataset result, IndexIterator iter) {
        IndexIterator riter = result.getIterator();
        result.setDirty();
        float[] rdata = ((FloatDataset)result).data;
        while (riter.hasNext() && iter.hasNext()) {
            rdata[riter.index] = this.data[iter.index];
        }
    }

    @Override
    public FloatDataset setByBoolean(Object obj, Dataset selection) {
        this.setDirty();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            int length = ((Number)selection.sum(new boolean[0])).intValue();
            if (length != ds.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext() && oiter.hasNext()) {
                this.data[biter.index] = (float)ds.getElementDoubleAbs(oiter.index);
            }
        } else {
            float dv = (float)DTypeUtils.toReal(obj);
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext()) {
                this.data[biter.index] = dv;
            }
        }
        return this;
    }

    @Override
    public FloatDataset setBy1DIndex(Object obj, Dataset index) {
        this.setDirty();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (index.getSize() != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index dataset does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext() && oiter.hasNext()) {
                this.data[iter.index] = (float)ds.getElementDoubleAbs(oiter.index);
            }
        } else {
            float dv = (float)DTypeUtils.toReal(obj);
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext()) {
                this.data[iter.index] = dv;
            }
        }
        return this;
    }

    @Override
    public FloatDataset setByIndexes(Object obj, Object ... indexes) {
        this.setDirty();
        IntegersIterator iter = new IntegersIterator(this.shape, indexes);
        int[] pos = iter.getPos();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (ShapeUtils.calcSize(iter.getShape()) != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index datasets does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            while (iter.hasNext() && oiter.hasNext()) {
                this.setItem((float)ds.getElementDoubleAbs(oiter.index), pos);
            }
        } else {
            float dv = (float)DTypeUtils.toReal(obj);
            while (iter.hasNext()) {
                this.setItem(dv, pos);
            }
        }
        return this;
    }

    @Override
    FloatDataset setSlicedView(Dataset view, Dataset d) {
        this.setDirty();
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(view, d);
        while (it.hasNext()) {
            this.data[it.aIndex] = (float)it.bDouble;
        }
        return this;
    }

    @Override
    public FloatDataset setSlice(Object obj, IndexIterator siter) {
        this.setDirty();
        if (obj instanceof IDataset) {
            IDataset ds = (IDataset)obj;
            int[] oshape = ds.getShape();
            if (!ShapeUtils.areShapesCompatible(siter.getShape(), oshape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(oshape), Arrays.toString(siter.getShape())));
            }
            if (ds instanceof Dataset) {
                Dataset ads = (Dataset)ds;
                IndexIterator oiter = ads.getIterator();
                while (siter.hasNext() && oiter.hasNext()) {
                    this.data[siter.index] = (float)ads.getElementDoubleAbs(oiter.index);
                }
            } else {
                PositionIterator oiter = new PositionIterator(oshape);
                int[] pos = ((IndexIterator)oiter).getPos();
                while (siter.hasNext() && ((IndexIterator)oiter).hasNext()) {
                    this.data[siter.index] = ds.getFloat(pos);
                }
            }
        } else {
            try {
                float v = (float)DTypeUtils.toReal(obj);
                while (siter.hasNext()) {
                    this.data[siter.index] = v;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        return this;
    }

    @Override
    public void copyItemsFromAxes(int[] pos, boolean[] axes, Dataset dest) {
        float[] ddata = (float[])dest.getBuffer();
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        int[] sshape = ShapeUtils.squeezeShape(siter.getShape(), false);
        IndexIterator diter = dest.getSliceIterator(null, sshape, null);
        if (ddata.length < ShapeUtils.calcSize(sshape)) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        dest.setDirty();
        while (siter.hasNext() && diter.hasNext()) {
            ddata[diter.index] = this.data[siter.index];
        }
    }

    @Override
    public void setItemsOnAxes(int[] pos, boolean[] axes, Object src) {
        this.setDirty();
        float[] sdata = (float[])src;
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        if (sdata.length < ShapeUtils.calcSize(siter.getShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int i = 0;
        while (siter.hasNext()) {
            this.data[siter.index] = sdata[i];
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<int[]> findPositions(float value) {
        block2: {
            iter = this.getIterator(true);
            posns = new ArrayList<int[]>();
            pos = iter.getPos();
            if (!Float.isNaN(value)) ** GOTO lbl14
            while (iter.hasNext()) {
                if (!Double.isNaN(this.data[iter.index])) continue;
                posns.add((int[])pos.clone());
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (this.data[iter.index] != value) continue;
                posns.add((int[])pos.clone());
lbl14:
                // 3 sources

                ** while (iter.hasNext())
            }
        }
        return posns;
    }

    @Override
    public int[] maxPos(boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> md = this.getStats();
        List<int[]> max = md.getMaximumPositions(ignoreInvalids);
        if (max == null) {
            max = this.findPositions(md.getMaximum(ignoreInvalids).floatValue());
            md.setMaximumPositions(max, new boolean[0]);
        }
        return max.get(0);
    }

    @Override
    public int[] minPos(boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> md = this.getStats();
        List<int[]> min = md.getMinimumPositions(ignoreInvalids);
        if (min == null) {
            min = this.findPositions(md.getMinimum(ignoreInvalids).floatValue());
            md.setMinimumPositions(min, new boolean[0]);
        }
        return min.get(0);
    }

    @Override
    public boolean containsNans() {
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            if (!Float.isNaN(this.data[iter.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInfs() {
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            if (!Float.isInfinite(this.data[iter.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            float x = this.data[iter.index];
            if (!Float.isNaN(x) && !Float.isInfinite(x)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FloatDataset iadd(Object b) {
        block7: {
            block6: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                bOffset = bds.getOffset();
                if (useLong) {
                    lb = bds.getElementLongAbs(bOffset);
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = this.data[v0] + (float)lb;
                    }
                } else {
                    db = bds.getElementDoubleAbs(bOffset);
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (float)((double)this.data[v1] + db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl31
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] + (float)it.bLong;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (float)((double)this.data[v3] + it.bDouble);
lbl31:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public FloatDataset isubtract(Object b) {
        this.setDirty();
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            int bOffset = bds.getOffset();
            if (useLong) {
                long lb = bds.getElementLongAbs(bOffset);
                while (it.hasNext()) {
                    int n = it.index;
                    this.data[n] = this.data[n] - (float)lb;
                }
            } else {
                double db = bds.getElementDoubleAbs(bOffset);
                while (it.hasNext()) {
                    int n = it.index;
                    this.data[n] = (float)((double)this.data[n] - db);
                }
            }
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            if (useLong) {
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = this.data[n] - (float)it.bLong;
                }
            } else {
                it.setOutputDouble(true);
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = (float)((double)this.data[n] - it.bDouble);
                }
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FloatDataset imultiply(Object b) {
        block7: {
            block6: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                bOffset = bds.getOffset();
                if (useLong) {
                    lb = bds.getElementLongAbs(bOffset);
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = this.data[v0] * (float)lb;
                    }
                } else {
                    db = bds.getElementDoubleAbs(bOffset);
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (float)((double)this.data[v1] * db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl31
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] * (float)it.bLong;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (float)((double)this.data[v3] * it.bDouble);
lbl31:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FloatDataset idivide(Object b) {
        block7: {
            block6: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                bOffset = bds.getOffset();
                if (useLong) {
                    lb = bds.getElementLongAbs(bOffset);
                    it = this.getIterator();
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = this.data[v0] / (float)lb;
                    }
                } else {
                    db = bds.getElementDoubleAbs(bOffset);
                    it = this.getIterator();
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (float)((double)this.data[v1] / db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl32
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] / (float)it.bLong;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (float)((double)this.data[v3] / it.bDouble);
lbl32:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public FloatDataset ifloor() {
        this.setDirty();
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            this.data[it.index] = (float)Math.floor(this.data[it.index]);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FloatDataset iremainder(Object b) {
        block7: {
            block6: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                bOffset = bds.getOffset();
                if (useLong) {
                    lb = bds.getElementLongAbs(bOffset);
                    it = this.getIterator();
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = this.data[v0] % (float)lb;
                    }
                } else {
                    lb = bds.getElementLongAbs(bOffset);
                    it = this.getIterator();
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = this.data[v1] % (float)lb;
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl32
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = this.data[v2] % (float)it.bLong;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (float)((double)this.data[v3] % it.bDouble);
lbl32:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FloatDataset ipower(Object b) {
        block8: {
            block7: {
                this.setDirty();
                v0 = bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                if (bds.getSize() != 1) break block7;
                bOffset = bds.getOffset();
                vr = bds.getElementDoubleAbs(bOffset);
                it = this.getIterator();
                if (!bds.isComplex()) ** GOTO lbl24
                vi = bds.getElementDoubleAbs(bOffset + 1);
                if (vi == 0.0) {
                    while (it.hasNext()) {
                        v = Math.pow(this.data[it.index], vr);
                        this.data[it.index] = (float)v;
                    }
                } else {
                    zv = new Complex(vr, vi);
                    while (it.hasNext()) {
                        zd = new Complex((double)this.data[it.index], 0.0);
                        v = zd.pow(zv).getReal();
                        this.data[it.index] = (float)v;
                    }
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    v = Math.pow(this.data[it.index], vr);
                    this.data[it.index] = (float)v;
lbl24:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl25:
                // 1 sources

                break block8;
            }
            it = BroadcastIterator.createIterator(this, bds);
            it.setOutputDouble(true);
            if (!bds.isComplex()) ** GOTO lbl38
            while (it.hasNext()) {
                zv = new Complex(it.bDouble, bds.getElementDoubleAbs(it.bIndex + 1));
                v = new Complex(it.aDouble, 0.0).pow(zv).getReal();
                this.data[it.aIndex] = (float)v;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                v = Math.pow(it.aDouble, it.bDouble);
                this.data[it.aIndex] = (float)v;
lbl38:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastIterator it = BroadcastIterator.createIterator(this, bds);
        it.setOutputDouble(true);
        double sum = 0.0;
        double comp = 0.0;
        if (ignoreNaNs) {
            if (w == null) {
                while (it.hasNext()) {
                    double diff = it.aDouble - it.bDouble;
                    if (Double.isNaN(diff)) continue;
                    double err = diff * diff - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                }
            } else {
                IndexIterator itw = w.getIterator();
                while (it.hasNext() && itw.hasNext()) {
                    double diff = it.aDouble - it.bDouble;
                    if (Double.isNaN(diff)) continue;
                    double err = diff * diff * w.getElementDoubleAbs(itw.index) - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                }
            }
        } else if (w == null) {
            while (it.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        } else {
            IndexIterator itw = w.getIterator();
            while (it.hasNext() && itw.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff * w.getElementDoubleAbs(itw.index) - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        }
        return sum;
    }
}

