/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

abstract class MedianOfTwoSortedSets {
    int nB;
    int nA;
    int diff;
    int diffLeft;

    MedianOfTwoSortedSets() {
    }

    public final double get() {
        int leftA = 0;
        int leftB = 0;
        int rightA = this.nB - 1;
        int rightB = this.nB - 1;
        while (this.nB > 1) {
            int medianIndex = (int)Math.floor((this.nB + 1) / 2) - 1;
            int medianAIndex = leftA + medianIndex;
            int medianBIndex = leftB + medianIndex;
            double medA = this.getAm(medianAIndex);
            double medB = this.getBm(medianBIndex);
            int smallerShift = 0;
            if (this.nB % 2 == 0) {
                smallerShift = 1;
            }
            if (medA >= medB) {
                rightA = medianAIndex;
                leftB = medianBIndex + smallerShift;
            } else {
                rightB = medianBIndex;
                leftA = medianAIndex + smallerShift;
            }
            this.nB = rightB - leftB + 1;
        }
        return Math.min(this.getAm(leftA), this.getBm(leftB));
    }

    private double getAm(int i) {
        int firstElement = this.diffLeft;
        int lastElement = this.diffLeft + this.nA - 1;
        if (i < firstElement) {
            return Double.NEGATIVE_INFINITY;
        }
        if (i > lastElement) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getA(i - this.diffLeft);
    }

    private double getBm(int i) {
        return this.getB(i);
    }

    protected abstract double getA(int var1);

    protected abstract double getB(int var1);

    protected void setDiffs() {
        this.diff = this.nB - this.nA;
        this.diffLeft = this.diff / 2;
    }
}

