/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.Slice;

public class IntegersIterator
extends IndexIterator {
    private final int[] ishape;
    private final int irank;
    private final int[] oshape;
    private final int orank;
    private int offset;
    private int srank;
    private final IndexIterator it;
    private final int[] ipos;
    private final int[] opos;
    private final List<Object> indexes;

    public IntegersIterator(int[] shape, Object ... index) {
        this(false, shape, index);
    }

    /*
     * WARNING - void declaration
     */
    public IntegersIterator(boolean restrict1D, int[] shape, Object ... index) {
        int i;
        void var8_17;
        if (shape == null) {
            this.ishape = null;
            this.irank = 0;
        } else {
            this.ishape = (int[])shape.clone();
            this.irank = shape.length;
        }
        if (this.irank < index.length) {
            throw new IllegalArgumentException("Number of index datasets is greater than rank of dataset");
        }
        this.indexes = new ArrayList<Object>();
        Object[] objectArray = index;
        int n = index.length;
        int n2 = 0;
        while (n2 < n) {
            Object i2 = objectArray[n2];
            if (i2 instanceof BooleanDataset) {
                for (IntegerDataset integerDataset : Comparisons.nonZero((Dataset)i2)) {
                    this.indexes.add(integerDataset);
                }
            } else if (i2 == null || i2 instanceof Slice) {
                this.indexes.add(i2);
            } else if (i2 instanceof IntegerDataset) {
                Dataset dataset = (Dataset)i2;
                int r = dataset.getRank();
                if (restrict1D && r > 1) {
                    throw new IllegalArgumentException("Integer datasets were restricted to zero or one dimensions");
                }
                if (r == 0) {
                    i2 = dataset.reshape(1);
                }
                this.indexes.add(i2);
            } else {
                throw new IllegalArgumentException("Unsupported object for indexing");
            }
            ++n2;
        }
        if (this.indexes.size() < this.irank) {
            int i3 = this.indexes.size();
            while (i3 < this.irank) {
                this.indexes.add(null);
                ++i3;
            }
        } else if (this.indexes.size() > this.irank) {
            throw new IllegalArgumentException("Too many indices (a boolean dataset may have too many dimensions)");
        }
        int ilength = -1;
        int[] cshape = null;
        int first = -1;
        boolean intact = true;
        this.srank = 0;
        boolean bl = false;
        while (var8_17 < this.irank) {
            Object obj = this.indexes.get((int)var8_17);
            if (obj instanceof IntegerDataset && !restrict1D) {
                int l;
                IntegerDataset ind = (IntegerDataset)obj;
                if (first > 0) {
                    intact = false;
                }
                if (ilength < (l = ind.size)) {
                    ilength = l;
                    cshape = null;
                } else if (l != 1 && l != ilength) {
                    throw new IllegalArgumentException("Index datasets do not have same size");
                }
                if (cshape == null) {
                    cshape = ind.shape;
                    this.srank = cshape.length;
                    this.offset = var8_17;
                } else if (l > 1 && !Arrays.equals(ind.shape, cshape)) {
                    throw new IllegalArgumentException("Index datasets do not have same shape");
                }
            } else if (cshape != null && first < 0) {
                first = var8_17;
            }
            ++var8_17;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.irank);
        if (intact) {
            boolean used = false;
            int i5 = 0;
            while (i5 < this.irank) {
                Object obj = this.indexes.get(i5);
                if (obj instanceof IntegerDataset) {
                    if (restrict1D || !used) {
                        int[] lshape;
                        used = true;
                        int[] nArray = lshape = restrict1D ? ((IntegerDataset)obj).shape : cshape;
                        int n3 = lshape.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            int j = nArray[n4];
                            arrayList.add(j);
                            ++n4;
                        }
                    }
                } else if (obj instanceof Slice) {
                    Slice s = (Slice)obj;
                    int l = this.ishape[i5];
                    s.setLength(l);
                    arrayList.add(s.getNumSteps());
                } else {
                    arrayList.add(this.ishape[i5]);
                }
                ++i5;
            }
        } else {
            assert (cshape != null);
            int[] s = cshape;
            int obj = cshape.length;
            int i5 = 0;
            while (i5 < obj) {
                void j = s[i5];
                arrayList.add((int)j);
                ++i5;
            }
            i = 0;
            while (i < this.irank) {
                Object obj2 = this.indexes.get(i);
                if (obj2 == null) {
                    arrayList.add(this.ishape[i]);
                } else if (obj2 instanceof Slice) {
                    Slice s2 = (Slice)obj2;
                    int l = this.ishape[i];
                    s2.setLength(l);
                    arrayList.add(s2.getNumSteps());
                }
                ++i;
            }
        }
        this.orank = arrayList.size();
        this.oshape = (int[])(this.orank == 0 && this.ishape == null ? null : new int[this.orank]);
        i = 0;
        while (i < this.orank) {
            this.oshape[i] = (Integer)arrayList.get(i);
            ++i;
        }
        i = 0;
        while (i < this.irank) {
            IntegerDataset ind;
            Object obj = this.indexes.get(i);
            if (obj instanceof IntegerDataset && (ind = (IntegerDataset)obj).getSize() > 0) {
                int l = this.ishape[i];
                if (ind.min(new boolean[0]).intValue() < -l || ind.max(new boolean[0]).intValue() >= l) {
                    throw new IllegalArgumentException("A value in index datasets is outside permitted range");
                }
            }
            ++i;
        }
        this.ipos = new int[this.irank];
        this.it = new PositionIterator(this.oshape);
        this.opos = this.it.getPos();
    }

    @Override
    public int[] getShape() {
        return this.oshape;
    }

    @Override
    public boolean hasNext() {
        if (this.it.hasNext()) {
            int[] spos;
            int i = 0;
            while (i < this.offset) {
                Object obj = this.indexes.get(i);
                if (obj == null) {
                    this.ipos[i] = this.opos[i];
                } else if (obj instanceof Slice) {
                    Slice s = (Slice)obj;
                    this.ipos[i] = s.getPosition(this.opos[i]);
                } else {
                    throw new IllegalStateException("Bad state: index dataset before offset");
                }
                ++i;
            }
            int[] nArray = spos = this.srank > 0 ? Arrays.copyOfRange(this.opos, i, i + this.srank) : this.opos;
            if (spos == this.opos) {
                while (i < this.irank) {
                    Object obj = this.indexes.get(i);
                    if (obj == null) {
                        this.ipos[i] = this.opos[i];
                    } else if (obj instanceof Slice) {
                        Slice s = (Slice)obj;
                        this.ipos[i] = s.getPosition(this.opos[i]);
                    } else if (obj instanceof IntegerDataset) {
                        int p = ((Dataset)obj).getInt(this.opos[i]);
                        this.ipos[i] = p < 0 ? p + this.ishape[i] : p;
                    } else {
                        throw new IllegalStateException("Bad state: index dataset after subspace");
                    }
                    ++i;
                }
            } else {
                Object obj;
                int j = 0;
                while (j < this.irank) {
                    obj = this.indexes.get(j);
                    if (obj instanceof IntegerDataset) {
                        IntegerDataset ind = (IntegerDataset)obj;
                        int p = ind.size > 1 ? ind.get(spos) : ind.getAbs(0);
                        this.ipos[i] = p < 0 ? p + this.ishape[i] : p;
                        ++i;
                    }
                    ++j;
                }
                int o = this.orank - this.irank;
                while (i < this.irank) {
                    obj = this.indexes.get(i);
                    if (obj == null) {
                        this.ipos[i] = this.opos[i + o];
                    } else if (obj instanceof Slice) {
                        Slice s = (Slice)obj;
                        this.ipos[i] = s.getPosition(this.opos[i + o]);
                    } else {
                        throw new IllegalStateException("Bad state: index dataset after subspace");
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int[] getPos() {
        return this.ipos;
    }

    @Override
    public void reset() {
        this.it.reset();
        Arrays.fill(this.ipos, 0);
        this.index = 0;
    }
}

