/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.docgen.wizard.general;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.Wizard;
import org.polarsys.kitalpha.pdt.docgen.wizard.actions.HTMLDocLoaderAndLauncher;
import org.polarsys.kitalpha.pdt.docgen.wizard.general.HTMLDocGenContext;

public class HTMLDocGenWizard
extends Wizard {
    private IFile selection;
    private String modelPath;
    private String projectName;
    private String cssDestinationFolder = "/css";
    private String cssSourceFolder = "platform:/plugin/org.polarsys.kitalpha.pdt.docgen/CSS";

    public HTMLDocGenWizard(IFile selection) {
        this.selection = selection;
        this.setWindowTitle("HTML documentation generation");
        this.setNeedsProgressMonitor(false);
    }

    public boolean performFinish() {
        this.projectName = this.selection.getProject().getName();
        this.modelPath = String.valueOf(this.projectName) + "/" + this.selection.getProjectRelativePath().toString();
        HTMLDocGenContext context = HTMLDocGenContext.INSTANCE;
        if (context.currentRepositoryIsChecked()) {
            context.setProjectName(this.projectName);
            IContainer currentFolder = this.selection.getParent();
            if (currentFolder instanceof IFolder) {
                context.setOutputFolderName(((IFolder)currentFolder).getName());
            }
        }
        context.setCSSSourceFolder(this.cssSourceFolder);
        context.setCSSOutputFolder(this.cssDestinationFolder);
        context.setModelPath(this.modelPath);
        context.setPlatformModelURI(URI.createPlatformResourceURI((String)this.modelPath, (boolean)true));
        HTMLDocLoaderAndLauncher HTMLlauncher = new HTMLDocLoaderAndLauncher();
        HTMLlauncher.launchActivity();
        return true;
    }
}

