/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.coredomain.model.edit.helpers;

import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.polarsys.kitalpha.ad.common.AD_Log;

public class AbstractHelper {
    protected final String pathToExclude;
    protected final String project;

    public AbstractHelper(EObject target) {
        URI uri = target.eResource().getURI();
        this.pathToExclude = new Path(uri.path()).removeFirstSegments(1).toPortableString();
        this.project = uri.segment(1);
    }

    protected void fillScope(IPluginModelBase model, Set<String> bundleScope) {
        BundleDescription description = model.getBundleDescription();
        String symbolicName = description.getSymbolicName();
        if (bundleScope.contains(symbolicName)) {
            return;
        }
        bundleScope.add(symbolicName);
        BundleSpecification[] bundleSpecificationArray = description.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification req = bundleSpecificationArray[n2];
            if (req.getSupplier() == null) {
                AD_Log.getDefault().logWarning(NLS.bind((String)"Cannot find supplier for ''{0}''", (Object)req.hashCode()));
            } else {
                IPluginModelBase reqModel = PluginRegistry.findModel((BundleDescription)req.getSupplier().getSupplier());
                this.fillScope(reqModel, bundleScope);
            }
            ++n2;
        }
    }

    public String getProject() {
        return this.project;
    }
}

