/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension;

import com.ibm.icu.text.Collator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.osgi.util.NLS;
import org.polarsys.kitalpha.emde.extension.i18n.Messages;
import org.polarsys.kitalpha.emde.extension.registry.ItemProviderAdapterFactoriesRegistryProvider;
import org.polarsys.kitalpha.emde.extension.registry.URIFactory;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public abstract class Model<T extends Model<T>>
implements Comparable<T> {
    static final String SEPARATOR = "<-|-|->";
    private static final Collator collator = Collator.getInstance();
    private EPackage ePackage;
    private final String nsURI;
    private final URIFactory uriFactory;

    public Model(String name, URIFactory uriFactory) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((name.trim().length() > 0 ? 1 : 0) != 0);
        this.nsURI = name.trim();
        Assert.isNotNull((Object)uriFactory);
        this.uriFactory = uriFactory;
    }

    public EPackage getEPackage() {
        if (this.ePackage != null) {
            return this.ePackage;
        }
        if (this.getName() != null) {
            this.ePackage = EPackage.Registry.INSTANCE.getEPackage(this.getName());
        }
        return this.ePackage;
    }

    public abstract String getPath();

    public String getName() {
        return this.nsURI;
    }

    public URIFactory getURIFactory() {
        return this.uriFactory;
    }

    public AdapterFactory getAdapterFactory() {
        try {
            return this.uriFactory.getAdapterFactory();
        }
        catch (CoreException ce) {
            String msg = NLS.bind((String)Messages.ImplementationRegistryProvider_invalidClass, (Object[])new String[]{ItemProviderAdapterFactoriesRegistryProvider.getName(), this.uriFactory.getAdapterFactoryName(), AdapterFactory.class.getName()});
            Log.getDefault().logError(msg, (Throwable)ce);
            return null;
        }
    }

    @Override
    public int compareTo(T other_p) {
        return collator.compare(this.getName(), ((Model)other_p).getName());
    }

    public abstract String getQualifiedName();
}

