/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree;

import java.util.Collection;
import java.util.HashSet;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.IViewpointTreeDescription;

public class ViewpointTreeContainer {
    private Collection<IViewpointTreeDescription> roots = new HashSet<IViewpointTreeDescription>();

    public Collection<IViewpointTreeDescription> getRoots() {
        return this.roots;
    }

    public ViewpointTreeContainer add(IViewpointTreeDescription vp) {
        if (!vp.hasParents()) {
            this.getRoots().add(vp);
        }
        return this;
    }

    public Collection<String> getSelectedUris() {
        HashSet<String> collector = new HashSet<String>();
        this.collectSelectedUris(this.roots, collector);
        return collector;
    }

    private void collectSelectedUris(Collection<IViewpointTreeDescription> roots, Collection<String> collector) {
        for (IViewpointTreeDescription vpd : roots) {
            if (vpd.isCandidateToKeep()) {
                collector.addAll(vpd.getViewpointNsUri());
            }
            this.collectSelectedUris(vpd.getChildren(), collector);
        }
    }

    public Collection<String> getViewpointToRemove() {
        HashSet<String> vps = new HashSet<String>();
        for (IViewpointTreeDescription vpd : this.roots) {
            if (!vpd.isCandidateToKeep()) {
                vps.add(vpd.getViewpointId());
            }
            this.collectViewpointChildrenToRemove(vpd.getChildren(), vps);
        }
        return vps;
    }

    public Collection<String> getUriToRemove() {
        HashSet<String> uris = new HashSet<String>();
        for (IViewpointTreeDescription vpd : this.roots) {
            if (!vpd.isCandidateToKeep()) {
                uris.addAll(vpd.getViewpointNsUri());
            }
            this.collectUriChildrenToRemove(vpd.getChildren(), uris);
        }
        return uris;
    }

    public void collectUriChildrenToRemove(Collection<IViewpointTreeDescription> children, Collection<String> uriToRemove) {
        if (children.isEmpty()) {
            return;
        }
        for (IViewpointTreeDescription child : children) {
            if (!child.isCandidateToKeep()) {
                uriToRemove.addAll(child.getViewpointNsUri());
            }
            this.collectUriChildrenToRemove(child.getChildren(), uriToRemove);
        }
    }

    protected void collectViewpointChildrenToRemove(Collection<IViewpointTreeDescription> children, Collection<String> viewpointToRemove) {
        if (children.isEmpty()) {
            return;
        }
        for (IViewpointTreeDescription child : children) {
            if (!child.isCandidateToKeep()) {
                viewpointToRemove.add(child.getViewpointId());
            }
            this.collectViewpointChildrenToRemove(child.getChildren(), viewpointToRemove);
        }
    }

    public Collection<String> getAllViewpointsNSuri() {
        HashSet<String> nsuris = new HashSet<String>();
        for (IViewpointTreeDescription vpd : this.getRoots()) {
            nsuris.addAll(vpd.getViewpointNsUri());
            this.getAllNsUrisOfChildren(vpd.getChildren(), nsuris);
        }
        return nsuris;
    }

    private void getAllNsUrisOfChildren(Collection<IViewpointTreeDescription> children, Collection<String> nsuris) {
        if (children.isEmpty()) {
            return;
        }
        for (IViewpointTreeDescription child : children) {
            nsuris.addAll(child.getViewpointNsUri());
            this.getAllNsUrisOfChildren(child.getChildren(), nsuris);
        }
    }

    public void dispose() {
        this.roots.clear();
    }
}

