/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.diffmerge.bridge.integration.transposer;

import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.impl.emf.EMFSymbolFunction;
import org.eclipse.emf.diffmerge.bridge.util.BaseTraceLoggingMessage;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.TransposerBridgeCause;
import org.polarsys.kitalpha.diffmerge.bridge.integration.transposer.TransposerBridgeContext;
import org.polarsys.kitalpha.transposer.transformation.context.ContextHelper;

public class TransposerTraceLoggingMessage
extends BaseTraceLoggingMessage {
    public TransposerTraceLoggingMessage(TransposerBridgeContext context_p, Object target_p, ICause<?> cause_p) {
        super(target_p, cause_p);
    }

    protected String getPrefix() {
        return "\t|\t|__Produced ";
    }

    protected String getMessageBody() {
        StringBuilder builder = new StringBuilder("(");
        builder.append(this.getTarget().getClass().getSimpleName()).append(" \"");
        builder.append(this.getObjectLabel(this.getTarget())).append("\"");
        EMFSymbolFunction function = EMFSymbolFunction.getInstance();
        builder.append("[").append(function.getSymbol(this.getTarget())).append("]");
        builder.append(") From {");
        for (Object source : this.getCause().getSourceElements()) {
            String sourceName = this.getObjectLabel(source);
            String sourceType = ((EObject)source).eClass().getName();
            builder.append("(");
            builder.append(sourceType).append(" \"");
            builder.append(sourceName).append("\"");
            builder.append("[").append(function.getSymbol(source)).append("])");
        }
        String role = ((TransposerBridgeCause)this.getCause()).getTransformationKey().getRole();
        if (!role.equals(ContextHelper.MAIN_ROLE)) {
            builder.append("|").append(role);
        }
        builder.append("}");
        return builder.toString();
    }
}

