/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers;

import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Property;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IConfigurationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IMetamodelHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IMiscHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IRepresentationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IRuleHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IServiceHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ModelListener;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ResourceManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointConfigurationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointMetamodelHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointMiscHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointRepresentationMetamodelHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointRuleHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointServiceHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.ConfigurationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.MetamodelHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.MiscHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.RepresentationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.RuleHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.ServiceHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.workspace.WorkspaceManager;

public class ModelManager {
    private ResourceManager resourceMgr;
    private IConfigurationHandler configurationHandler;
    private IRuleHandler ruleHandler;
    private IServiceHandler serviceHandler;
    private IRepresentationHandler representationHandler;
    private IMetamodelHandler metamodelHandler;
    private IMiscHandler miscHandler;
    private boolean local;

    public boolean isLocal() {
        return this.local;
    }

    public IMetamodelHandler getMetamodelHandler() {
        return this.metamodelHandler;
    }

    public IMiscHandler getMiscHandler() {
        return this.miscHandler;
    }

    public IConfigurationHandler getConfigurationHandler() {
        return this.configurationHandler;
    }

    public IRuleHandler getRuleHandler() {
        return this.ruleHandler;
    }

    public IServiceHandler getServiceHandler() {
        return this.serviceHandler;
    }

    public void addListener(ModelListener list) {
        this.resourceMgr.addListener(list);
    }

    public void removeListener(ModelListener list) {
        this.resourceMgr.removeListener(list);
    }

    public IRepresentationHandler getRepresentationHandler() {
        return this.representationHandler;
    }

    public ResourceManager getResourceManager() {
        return this.resourceMgr;
    }

    public boolean isRemovable(ViewpointElement element) {
        if (element instanceof Property) {
            return this.getConfigurationHandler().isRemovable(element);
        }
        if (element instanceof Rule) {
            return this.getRuleHandler().isRemovable(element);
        }
        if (element instanceof Service) {
            return this.getServiceHandler().isRemovable(element);
        }
        throw new IllegalStateException();
    }

    public void dispose() {
        this.resourceMgr.dispose();
        this.configurationHandler = null;
        this.serviceHandler = null;
        this.ruleHandler = null;
        this.resourceMgr = null;
    }

    public static ModelManager createViewpointManager(Viewpoint vp) {
        ViewpointManager mgr = new ViewpointManager(vp);
        ModelManager mmgr = new ModelManager();
        mmgr.resourceMgr = mgr;
        mmgr.local = false;
        mmgr.ruleHandler = new ViewpointRuleHandler(vp, mgr);
        mmgr.configurationHandler = new ViewpointConfigurationHandler(vp, mgr);
        mmgr.serviceHandler = new ViewpointServiceHandler(vp, mgr);
        mmgr.metamodelHandler = new ViewpointMetamodelHandler(vp, mgr);
        mmgr.miscHandler = new ViewpointMiscHandler(vp, mgr);
        mmgr.representationHandler = new ViewpointRepresentationMetamodelHandler(vp, mgr);
        return mmgr;
    }

    public static ModelManager createWorkspaceManager(Viewpoint viewpoint) {
        WorkspaceManager mgr = WorkspaceManager.INSTANCE;
        ModelManager mmgr = new ModelManager();
        mmgr.resourceMgr = mgr;
        mmgr.local = true;
        mmgr.miscHandler = new MiscHandler(viewpoint, mgr);
        mmgr.metamodelHandler = new MetamodelHandler(viewpoint, mgr);
        mmgr.ruleHandler = new RuleHandler(viewpoint, mgr);
        mmgr.configurationHandler = new ConfigurationHandler(viewpoint, mgr);
        mmgr.serviceHandler = new ServiceHandler(viewpoint, mgr);
        mmgr.representationHandler = new RepresentationHandler(viewpoint, mgr);
        return mmgr;
    }
}

