/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.share.ui.utilities;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.IViewpointTreeDescription;

public class ExtensionTreeViewer
extends ContainerCheckedTreeViewer {
    public ExtensionTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExtensionTreeViewer.this.doCheckStateChanged(event.getElement(), event.getChecked());
            }
        });
    }

    protected void doCheckStateChanged(Object element, boolean state) {
        IViewpointTreeDescription selected_vpd = (IViewpointTreeDescription)element;
        if (selected_vpd != null) {
            boolean checked = state;
            this.setGrayChecked(selected_vpd, false);
            selected_vpd.setAsCandidateToKeep(checked);
            selected_vpd.updateCandidates(selected_vpd.isCandidateToKeep());
            TreeItem[] allItems = this.getTree().getItems();
            this.updateCheckItems(allItems);
        }
    }

    protected void doCheckStateChanged(Object element) {
    }

    private void allChecked(boolean state, Object[] items) {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        int i = 0;
        while (i < items.length) {
            this.setChecked(items[i], state);
            Object[] children = cp.getElements(items[i]);
            this.allChecked(state, children);
            ++i;
        }
    }

    public void allChecked(boolean state) {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        Object[] elements = cp.getElements(this.getInput());
        this.allChecked(state, elements);
    }

    private void updateCheckItems(TreeItem[] allItems) {
        TreeItem[] treeItemArray = allItems;
        int n = allItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            IViewpointTreeDescription vpd = (IViewpointTreeDescription)treeItem.getData();
            treeItem.setChecked(vpd.isCandidateToKeep());
            treeItem.setGrayed(false);
            this.updateCheckChildrenItems(treeItem.getItems());
            ++n2;
        }
    }

    private void updateCheckChildrenItems(TreeItem[] items) {
        if (items == null) {
            return;
        }
        if (items.length == 0) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            IViewpointTreeDescription vpd = (IViewpointTreeDescription)treeItem.getData();
            treeItem.setChecked(vpd.isCandidateToKeep());
            treeItem.setGrayed(false);
            this.updateCheckChildrenItems(treeItem.getItems());
            ++n2;
        }
    }
}

