/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.integration.services;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Service;
import org.polarsys.kitalpha.ad.viewpoint.integration.services.ServiceImplementation;

public class Implementations {
    private static final String EXTENSION_POINT_ID = "org.polarsys.kitalpha.ad.viewpoint.implementation.services";
    private static final String LABEL = "label";

    public static String toString(List<Rule> rules) {
        StringBuilder str = new StringBuilder();
        for (Rule rule : rules) {
            if (str.length() != 0) {
                str.append(", ");
            }
            str.append(rule.getId());
        }
        return str.toString();
    }

    public static boolean hasProvider(Bundle bundle) {
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(bundle.getSymbolicName());
        if (model == null) {
            return false;
        }
        IPluginExtension[] iPluginExtensionArray = model.getExtensions().getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            if (EXTENSION_POINT_ID.equals(extension.getPoint())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String[] getAvailableActionLabels() {
        IConfigurationElement[] configurationElements;
        HashSet<String> types = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            types.add(elt.getAttribute(LABEL));
            ++n2;
        }
        Object[] array = types.toArray(new String[types.size()]);
        Arrays.sort(array);
        return array;
    }

    public static String getLabel(String type) {
        IConfigurationElement[] configurationElements;
        if (type == null) {
            return "";
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            if (elt.getAttribute("type").equals(type)) {
                return elt.getAttribute(LABEL);
            }
            ++n2;
        }
        return "Missing - May be not loaded yet";
    }

    public static String getType(String label) {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            if (elt.getAttribute(LABEL).equals(label)) {
                return elt.getAttribute("type");
            }
            ++n2;
        }
        AD_Log.getDefault().logError("Cannot find type for service label='" + label + "'");
        return "Unknown";
    }

    public static ServiceImplementation getInstance(Service service) throws CoreException {
        IConfigurationElement[] configurationElements;
        String type = service.getType();
        if (type == null || "".equals(type)) {
            throw new NullPointerException("No type for service " + service.getId());
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elt = iConfigurationElementArray[n2];
            String typeAttribute = elt.getAttribute("type");
            if (type.equals(typeAttribute)) {
                return (ServiceImplementation)elt.createExecutableExtension("class");
            }
            ++n2;
        }
        return null;
    }

    private Implementations() {
    }

    public static class LoadingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LoadingException(Throwable cause) {
            super(cause);
        }
    }
}

