/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.kitalpha.ad.viewpoint.predicate.factories.FactoryProvider;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Action;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Predicate;
import org.polarsys.kitalpha.ad.viewpoint.predicate.interfaces.Transition;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.Activator;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.engine.impl.InternalTransition;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager.AbstractExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager.ActionExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager.ExtensionConstantes;
import org.polarsys.kitalpha.ad.viewpoint.predicate.internal.extension.manager.PredicateExtensionManager;

public class TransitionExtensionManager
extends AbstractExtensionManager {
    private static final TransitionExtensionManager INSTANCE = new TransitionExtensionManager();

    public static synchronized TransitionExtensionManager getInstance() {
        return INSTANCE;
    }

    public Transition retriveTransition(String viewpointID, String actionID) {
        IConfigurationElement[] transitions = (IConfigurationElement[])this.getExtensionFor.apply("org.polarsys.kitalpha.ad.viewpoint.transition");
        Stream<IConfigurationElement> stream = Arrays.stream(transitions);
        List filtredTransactions = stream.filter(e -> e.getAttribute("viewpointID").equals(viewpointID) && e.getAttribute("actionID").equals(actionID)).collect(Collectors.toList());
        try {
            Action action = ActionExtensionManager.getInstance().retriveAction(actionID);
            InternalTransition transition = (InternalTransition)FactoryProvider.getTransitionFactory().createTransition(viewpointID, actionID, action);
            for (IConfigurationElement c : filtredTransactions) {
                IConfigurationElement[] children = c.getChildren();
                Stream<IConfigurationElement> childrenStream = Arrays.stream(children);
                List predicateIDs = childrenStream.filter(e -> e.getName().equals("Predicate")).map(e -> e.getAttribute("predicateID")).collect(Collectors.toList());
                for (String pid : predicateIDs) {
                    IConfigurationElement elt = PredicateExtensionManager.getInstance().retrivePredicateConfigurationElement(pid);
                    Predicate predicate = PredicateExtensionManager.getInstance().createPredicate(elt);
                    transition.addPredicate(pid, predicate);
                    String message = PredicateExtensionManager.getInstance().getDiagnosticMessageForPredicate(elt);
                    if (message == null || message.isEmpty()) continue;
                    transition.addDiagnostic(pid, message);
                }
            }
            return transition;
        }
        catch (CoreException e1) {
            Status status = new Status(4, "org.polarsys.kitalpha.ad.viewpoint.predicate", "An error is occured while reading transition extension point", (Throwable)e1);
            Activator.getDefault().getLog().log((IStatus)status);
            return FactoryProvider.getTransitionFactory().createTransition("", "", ExtensionConstantes.NOP, new HashMap<String, Predicate>());
        }
    }
}

