/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc.CoreDomainViewpointHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.helper.URIConverterHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;

public class NsUriFinder {
    public static Set<String> getViewpointEPackagesNSURI(EObject model, IExternalContentSupport.IExternalContentProvider externalProvider) {
        String projectName = ResourceHelper.getProjectName((EObject)model);
        org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp = NsUriFinder.getRootViewpoint(model, projectName, externalProvider);
        HashSet<String> uris = new HashSet();
        uris = NsUriFinder.getUsedModel(vp);
        return uris;
    }

    private static Set<String> getUsedModel(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp) {
        HashSet<String> uris = new HashSet<String>();
        if (vp.getUseAnyEMFResource() != null && !vp.getUseAnyEMFResource().isEmpty()) {
            uris.addAll((Collection<String>)vp.getUseAnyEMFResource());
        }
        if (vp.getUseAnyEMFResource() != null && !vp.getUseAnyEMFResource().isEmpty()) {
            uris.addAll(NsUriFinder.getWSAndFSResource(vp));
        }
        uris.addAll(NsUriFinder.getUsedViewpointEPackages(vp));
        return uris;
    }

    private static Collection<? extends String> getWSAndFSResource(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp) {
        HashSet<String> uris = new HashSet<String>();
        for (String uri : vp.getUseFSResource()) {
            if (!uri.endsWith(".ecore")) continue;
            uris.add(uri);
        }
        for (String uri : vp.getUseWorkspaceResource()) {
            if (!uri.endsWith(".ecore")) continue;
            uris.add(uri);
        }
        return uris;
    }

    private static Collection<String> getUsedViewpointEPackages(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp) {
        EList viewpoints = vp.getUseViewpoint();
        HashSet<String> platformURIs = new HashSet<String>();
        for (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint : viewpoints) {
            String vpProjectName = ResourceHelper.getProjectName((EObject)viewpoint);
            String resource_id = vpProjectName.substring(0, vpProjectName.lastIndexOf("."));
            Viewpoint coreDomainViewpoint = CoreDomainViewpointHelper.getCoreDomainViewpoint((String)resource_id, null);
            if (coreDomainViewpoint == null) {
                throw new RuntimeException("Could not find the viewpoint resource for the project: " + vpProjectName);
            }
            EList packages = coreDomainViewpoint.getMetamodel().getModels();
            platformURIs.addAll(NsUriFinder.getPlatformURIsOfPackages((EList<EPackage>)packages));
        }
        return platformURIs;
    }

    private static Collection<String> getPlatformURIsOfPackages(EList<EPackage> packages) {
        HashSet<String> platformsUri = new HashSet<String>();
        for (EPackage ePackage : packages) {
            String nsuri = ePackage.getNsURI();
            URI uri = URI.createURI((String)nsuri);
            URI p_uri = URIConverterHelper.getPlatformURI((URI)uri);
            if (p_uri != null && !p_uri.isEmpty()) {
                platformsUri.add(p_uri.toString());
                continue;
            }
            Resource ePackageResource = ePackage.eResource();
            if (ePackageResource != null) {
                URI resource_uri = ePackageResource.getURI();
                if (resource_uri == null || resource_uri.isEmpty()) continue;
                platformsUri.add(resource_uri.toString());
                continue;
            }
            platformsUri.add(nsuri);
        }
        return platformsUri;
    }

    private static org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint getRootViewpoint(EObject model, String projectName, IExternalContentSupport.IExternalContentProvider externalProvider) {
        ResourceSetImpl fakeResourceSet = new ResourceSetImpl();
        org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint = null;
        ResourceHelper.loadPrimaryResource((String)projectName, (ResourceSet)fakeResourceSet);
        URI uri = ResourceHelper.getPrimaryResourceURI((String)projectName);
        XtextResource resource = (XtextResource)fakeResourceSet.getResource(uri, false);
        String text = null;
        IEditorReference vpspecEditor = NsUriFinder.getOpenedEditor(uri);
        try {
            if (vpspecEditor != null) {
                XtextEditor editor = (XtextEditor)vpspecEditor.getEditor(false);
                text = editor.getDirtyStateEditorSupport().getDirtyStateManager().getActualContentProvider().getContent(uri);
                if (text != null && !text.isEmpty() && resource != null) {
                    resource.reparse(text);
                } else if (resource != null) {
                    resource.load(Collections.emptyMap());
                }
            } else if (resource != null) {
                resource.load(Collections.emptyMap());
            }
            viewpoint = NsUriFinder.getCurrentViewpoint((Resource)resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return viewpoint;
    }

    private static org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint getCurrentViewpoint(Resource standaloneResource) {
        if (standaloneResource != null) {
            TreeIterator it = standaloneResource.getAllContents();
            while (it.hasNext()) {
                EObject v = (EObject)it.next();
                if (!(v instanceof org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)) continue;
                return (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)v;
            }
        }
        return null;
    }

    private static IEditorReference getOpenedEditor(URI uri) {
        IEditorReference[] editors;
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            String id = iEditorReference.getId();
            if (id.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec")) {
                try {
                    String segment;
                    String project;
                    IFile file = (IFile)iEditorReference.getEditorInput().getAdapter(IFile.class);
                    if (file != null && (project = file.getProject().getName().toString()).equalsIgnoreCase(segment = uri.segment(1))) {
                        return iEditorReference;
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }
}

