/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.category;

import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.explorer.contextual.category.ContextualExplorerCategoriesException;

public enum ContextualExplorerCategories {
    Parent(10),
    OwnedViewpointElement(20),
    OwnedExternalElement(30),
    ReferencedViewpointElement(40),
    ReferencedExternalElement(50),
    ReferencingViewpointElement(60);

    private int categoryId;

    private ContextualExplorerCategories(int id) {
        this.categoryId = id;
    }

    public String getTargetExplorerID() throws ContextualExplorerCategoriesException {
        switch (this.categoryId) {
            case 10: 
            case 20: 
            case 30: {
                return "CurrentElementExplorer";
            }
            case 40: 
            case 50: {
                return "ReferencedElementExplorer";
            }
            case 60: {
                return "ReferencingElementExplorer";
            }
        }
        throw new ContextualExplorerCategoriesException();
    }

    public String getCategoryIdentifier() throws ContextualExplorerCategoriesException {
        switch (this.categoryId) {
            case 10: {
                return "Parent";
            }
            case 20: {
                return "OwnedViewpointElements";
            }
            case 30: {
                return "OwnedMelodyAdvanceElements";
            }
            case 40: {
                return "ReferencedViewpointElements";
            }
            case 50: {
                return "ReferencedMelodyAdvanceElements";
            }
            case 60: {
                return "ReferencingViewpointElements";
            }
        }
        throw new ContextualExplorerCategoriesException();
    }

    public String getCategoryName() throws ContextualExplorerCategoriesException {
        switch (this.categoryId) {
            case 10: {
                return "Parent";
            }
            case 20: {
                return "Owned Viewpoint elements";
            }
            case 30: {
                return "Owned Melody Advance elements";
            }
            case 40: {
                return "Referenced viewpoint elements";
            }
            case 50: {
                return "Referenced Melody Advance elements";
            }
            case 60: {
                return "Referencing Viewpoint Element";
            }
        }
        throw new ContextualExplorerCategoriesException();
    }
}

