/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.mbsa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tigris.mtoolkit.iagent.internal.mbsa.DataFormater;

public abstract class MBSAReader {
    private byte[] data;
    private InputStream input;

    public MBSAReader(byte[] data) {
        this.data = data != null ? data : new byte[]{};
        this.input = new ByteArrayInputStream(this.data);
    }

    public byte[] getData() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    public byte readByte() throws IOException {
        return DataFormater.readByte(this.input);
    }

    public byte[] readByteArray() throws IOException {
        return DataFormater.readByteArray(this.input);
    }

    public short readShort() throws IOException {
        return DataFormater.readShort(this.input);
    }

    public short[] readShortArray() throws IOException {
        return DataFormater.readShortArray(this.input);
    }

    public int readInt() throws IOException {
        return DataFormater.readInt(this.input);
    }

    public int[] readIntArray() throws IOException {
        return DataFormater.readIntArray(this.input);
    }

    public long readLong() throws IOException {
        return DataFormater.readLong(this.input);
    }

    public long[] readLongArray() throws IOException {
        return DataFormater.readLongArray(this.input);
    }

    public short readWord() throws IOException {
        return DataFormater.readWord(this.input);
    }

    public short[] readWordArray() throws IOException {
        return DataFormater.readWordArray(this.input);
    }

    public int readDWord() throws IOException {
        return DataFormater.readDWord(this.input);
    }

    public int[] readDWordArray() throws IOException {
        return DataFormater.readDWordArray(this.input);
    }

    public long readQWord() throws IOException {
        return DataFormater.readQWord(this.input);
    }

    public long[] readQWordArray() throws IOException {
        return DataFormater.readQWordArray(this.input);
    }

    public String readString() throws IOException {
        return DataFormater.readString(this.input);
    }

    public String[] readStringArray() throws IOException {
        return DataFormater.readStringArray(this.input);
    }

    public byte readChar() throws IOException {
        return DataFormater.readChar(this.input);
    }

    public byte[] readCharArray() throws IOException {
        return DataFormater.readCharArray(this.input);
    }

    public int available() throws IOException {
        return this.input.available();
    }

    public void reset() {
        try {
            this.input.reset();
        }
        catch (IOException iOException) {}
    }
}

