/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.util.BitSet;
import java.util.jar.Attributes;
import org.osgi.service.deploymentadmin.DeploymentException;

public class AbstractInfo {
    private static final BitSet VALID_RESOURCE_PATH_CHARS;
    private final String m_path;
    private final Attributes m_attributes;
    private final boolean m_missing;

    public AbstractInfo(String path, Attributes attributes) throws DeploymentException {
        this.verifyEntryName(path);
        this.m_path = path;
        this.m_attributes = attributes;
        this.m_missing = this.parseBooleanHeader(attributes, "DeploymentPackage-Missing");
    }

    public String getPath() {
        return this.m_path;
    }

    public String getHeader(String header) {
        return this.m_attributes.getValue(header);
    }

    private void verifyEntryName(String name) throws DeploymentException {
        byte[] bytes = name.getBytes();
        boolean delimiterSeen = false;
        for (int j = 0; j < bytes.length; ++j) {
            if (!VALID_RESOURCE_PATH_CHARS.get(bytes[j])) {
                throw new DeploymentException(452, "Resource ID '" + name + "' contains invalid character(s)");
            }
            if (bytes[j] == 47) {
                if (delimiterSeen) {
                    throw new DeploymentException(452, "Resource ID '" + name + "' contains multiple consequetive path seperators");
                }
                delimiterSeen = true;
                continue;
            }
            delimiterSeen = false;
        }
    }

    public boolean isMissing() {
        return this.m_missing;
    }

    protected boolean parseBooleanHeader(Attributes attributes, String header) throws DeploymentException {
        String value = attributes.getValue(header);
        if (value != null) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new DeploymentException(452, "Invalid '" + header + "' header for manifest " + "entry '" + this.getPath() + "' header, should be either 'true' or 'false' or not present");
        }
        return false;
    }

    static {
        int i;
        VALID_RESOURCE_PATH_CHARS = new BitSet();
        for (i = 97; i <= 122; ++i) {
            VALID_RESOURCE_PATH_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            VALID_RESOURCE_PATH_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            VALID_RESOURCE_PATH_CHARS.set(i);
        }
        VALID_RESOURCE_PATH_CHARS.set(46);
        VALID_RESOURCE_PATH_CHARS.set(45);
        VALID_RESOURCE_PATH_CHARS.set(95);
        VALID_RESOURCE_PATH_CHARS.set(47);
    }
}

