/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.deploymentadmin.OutputtingInputStream;
import org.apache.felix.deploymentadmin.Utils;

class ExplodingOutputtingInputStream
extends OutputtingInputStream {
    private final ReaderThread m_task;

    public ExplodingOutputtingInputStream(InputStream inputStream, File indexFile, File contentDir) throws IOException {
        this(inputStream, new PipedOutputStream(), indexFile, contentDir);
    }

    private ExplodingOutputtingInputStream(InputStream inputStream, PipedOutputStream output, File index, File root) throws IOException {
        super(inputStream, output);
        this.m_task = new ReaderThread(output, index, root);
        this.m_task.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
            Exception exception = this.m_task.m_exception;
            if (exception != null) {
                throw (IOException)new IOException("Exception while processing the stream in the background: " + exception.getMessage()).initCause(exception);
            }
        }
        finally {
            this.waitFor();
        }
    }

    private void waitFor() {
        try {
            this.m_task.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static class ReaderThread
    extends Thread {
        private final File m_contentDir;
        private final File m_indexFile;
        private final PipedInputStream m_input;
        private volatile Exception m_exception;

        public ReaderThread(PipedOutputStream output, File index, File root) throws IOException {
            super("Apache Felix DeploymentAdmin - ExplodingOutputtingInputStream");
            this.m_contentDir = root;
            this.m_indexFile = index;
            this.m_input = new PipedInputStream(output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buffer = new byte[4096];
            ZipInputStream input = null;
            PrintWriter writer = null;
            try {
                input = new ZipInputStream(this.m_input);
                writer = new PrintWriter(new FileWriter(this.m_indexFile));
                ZipEntry entry = input.getNextEntry();
                while (entry != null) {
                    File current = new File(this.m_contentDir, entry.getName());
                    if (entry.isDirectory()) {
                        current.mkdirs();
                    } else {
                        writer.println(entry.getName());
                        File parent = current.getParentFile();
                        if (parent != null) {
                            parent.mkdirs();
                        }
                        OutputStream output = null;
                        try {
                            output = new GZIPOutputStream(new FileOutputStream(current));
                            int i = input.read(buffer);
                            while (i > -1) {
                                output.write(buffer, 0, i);
                                i = input.read(buffer);
                            }
                        }
                        finally {
                            output.close();
                        }
                    }
                    input.closeEntry();
                    writer.flush();
                    entry = input.getNextEntry();
                }
            }
            catch (IOException ex) {
                this.pushException(ex);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            try {
                Utils.readUntilEndOfStream(this.m_input);
            }
            catch (IOException e) {
                this.pushException(e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        this.pushException(e);
                    }
                }
            }
        }

        private void pushException(Exception e) {
            Exception e2 = new Exception(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            if (this.m_exception != null) {
                e2.initCause(this.m_exception);
            }
            this.m_exception = e2;
        }
    }
}

