/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.message;

import java.util.Optional;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;

public class KuraBirthPayload
extends KuraPayload {
    private static final String ACCEPT_ENCODING_KEY = "accept_encoding";
    private static final String APPLICATION_IDS_KEY = "application_ids";
    private static final String MODEM_IMEI_KEY = "modem_imei";
    private static final String MODEM_IMSI_KEY = "modem_imsi";
    private static final String MODEM_ICCID_KEY = "modem_iccid";
    private static final String MODEM_RSSI_KEY = "modem_rssi";
    private static final String MODEM_FIRMWARE_VERSION = "modem_firmware_version";
    private static final String PAYLOAD_ENCODING_KEY = "payload_encoding";
    private static final String TAMPER_STATUS = "tamper_status";

    public String getUptime() {
        return (String)this.getMetric("uptime");
    }

    public String getDisplayName() {
        return (String)this.getMetric("display_name");
    }

    public String getModelName() {
        return (String)this.getMetric("model_name");
    }

    public String getModelId() {
        return (String)this.getMetric("model_id");
    }

    public String getPartNumber() {
        return (String)this.getMetric("part_number");
    }

    public String getSerialNumber() {
        return (String)this.getMetric("serial_number");
    }

    public String getFirmwareVersion() {
        return (String)this.getMetric("firmware_version");
    }

    public String getBiosVersion() {
        return (String)this.getMetric("bios_version");
    }

    public String getCpuVersion() {
        return (String)this.getMetric("cpu_version");
    }

    public String getOs() {
        return (String)this.getMetric("os");
    }

    public String getOsVersion() {
        return (String)this.getMetric("os_version");
    }

    public String getJvmName() {
        return (String)this.getMetric("jvm_name");
    }

    public String getJvmVersion() {
        return (String)this.getMetric("jvm_version");
    }

    public String getJvmProfile() {
        return (String)this.getMetric("jvm_profile");
    }

    public TamperStatus getTamperStatus() {
        String tamperStatus = (String)this.getMetric(TAMPER_STATUS);
        if (tamperStatus == null) {
            return TamperStatus.UNSUPPORTED;
        }
        return TamperStatus.valueOf(tamperStatus);
    }

    @Deprecated
    public String getKuraVersion() {
        return (String)this.getMetric("kura_version");
    }

    public String getApplicationFramework() {
        String value = (String)this.getMetric("application_framework");
        if (value != null) {
            return value;
        }
        return "Kura";
    }

    public String getApplicationFrameworkVersion() {
        String value = (String)this.getMetric("application_framework_version");
        if (value != null) {
            return value;
        }
        return (String)this.getMetric("kura_version");
    }

    public String getConnectionInterface() {
        return (String)this.getMetric("connection_interface");
    }

    public String getConnectionIp() {
        return (String)this.getMetric("connection_ip");
    }

    public String getAcceptEncoding() {
        return (String)this.getMetric(ACCEPT_ENCODING_KEY);
    }

    public String getApplicationIdentifiers() {
        return (String)this.getMetric(APPLICATION_IDS_KEY);
    }

    public String getAvailableProcessors() {
        return (String)this.getMetric("available_processors");
    }

    public String getTotalMemory() {
        return (String)this.getMetric("total_memory");
    }

    public String getOsArch() {
        return (String)this.getMetric("os_arch");
    }

    public String getOsgiFramework() {
        return (String)this.getMetric("osgi_framework");
    }

    public String getOsgiFrameworkVersion() {
        return (String)this.getMetric("osgi_framework_version");
    }

    public String getModemImei() {
        return (String)this.getMetric(MODEM_IMEI_KEY);
    }

    public String getModemImsi() {
        return (String)this.getMetric(MODEM_IMSI_KEY);
    }

    public String getModemIccid() {
        return (String)this.getMetric(MODEM_ICCID_KEY);
    }

    public String getModemRssi() {
        return (String)this.getMetric(MODEM_RSSI_KEY);
    }

    public String getModemFirmwareVersion() {
        return (String)this.getMetric(MODEM_FIRMWARE_VERSION);
    }

    public String getPayloadEncoding() {
        return (String)this.getMetric(PAYLOAD_ENCODING_KEY);
    }

    public String getJvmVendor() {
        return (String)this.getMetric("jvm_vendor");
    }

    public String getJdkVendorVersion() {
        return (String)this.getMetric("jdk_vendor_version");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KuraBirthPayload [");
        sb.append("getUptime()=").append(this.getUptime()).append(", ");
        sb.append("getDisplayName()=").append(this.getDisplayName()).append(", ");
        sb.append("getModelName()=").append(this.getModelName()).append(", ");
        sb.append("getModelId()=").append(this.getModelId()).append(", ");
        sb.append("getPartNumber()=").append(this.getPartNumber()).append(", ");
        sb.append("getSerialNumber()=").append(this.getSerialNumber()).append(", ");
        sb.append("getFirmwareVersion()=").append(this.getFirmwareVersion()).append(", ");
        sb.append("getAvailableProcessors()=").append(this.getAvailableProcessors()).append(", ");
        sb.append("getTotalMemory()=").append(this.getTotalMemory()).append(", ");
        sb.append("getBiosVersion()=").append(this.getBiosVersion()).append(", ");
        sb.append("getCpuVersion()=").append(this.getCpuVersion()).append(", ");
        sb.append("getOs()=").append(this.getOs()).append(", ");
        sb.append("getOsVersion()=").append(this.getOsVersion()).append(", ");
        sb.append("getOsArch()=").append(this.getOsArch()).append(", ");
        sb.append("getJvmName()=").append(this.getJvmName()).append(", ");
        sb.append("getJvmVersion()=").append(this.getJvmVersion()).append(", ");
        sb.append("getJvmProfile()=").append(this.getJvmProfile()).append(", ");
        sb.append("getKuraVersion()=").append(this.getApplicationFrameworkVersion()).append(", ");
        sb.append("getApplicationFramework()=").append(this.getApplicationFramework()).append(", ");
        sb.append("getApplicationFrameworkVersion()=").append(this.getApplicationFrameworkVersion()).append(", ");
        sb.append("getOsgiFramework()=").append(this.getOsgiFramework()).append(", ");
        sb.append("getOsgiFrameworkVersion()=").append(this.getOsgiFrameworkVersion()).append(", ");
        sb.append("getConnectionInterface()=").append(this.getConnectionInterface()).append(", ");
        sb.append("getConnectionIp()=").append(this.getConnectionIp()).append(", ");
        sb.append("getAcceptEncoding()=").append(this.getAcceptEncoding()).append(", ");
        sb.append("getApplicationIdentifiers()=").append(this.getApplicationIdentifiers()).append(", ");
        sb.append("getPayloadEncoding()=").append(this.getPayloadEncoding()).append(", ");
        sb.append("getTamperStatus()=").append((Object)this.getTamperStatus()).append(", ");
        sb.append("getJvmVendor()=").append(this.getJvmVendor()).append(", ");
        sb.append("getJdkVendorVersion()=").append(this.getJdkVendorVersion());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addMetric(String name, Object value) {
        if (value != null) {
            super.addMetric(name, value);
        }
    }

    public static class KuraBirthPayloadBuilder {
        private String uptime;
        private String displayName;
        private String availableProcessors;
        private String totalMemory;
        private String osArch;
        private String modelName;
        private String modelId;
        private String partNumber;
        private String serialNumber;
        private String firmwareVersion;
        private String biosVersion;
        private String cpuVersion;
        private String os;
        private String osVersion;
        private String jvmName;
        private String jvmVersion;
        private String jvmProfile;
        private String jvmVendor;
        private Optional<String> jdkVendorVersion;
        private String kuraVersion;
        private String applicationFramework;
        private String applicationFrameworkVersion;
        private String connectionInterface;
        private String connectionIp;
        private String acceptEncoding;
        private String applicationIdentifiers;
        private String osgiFramework;
        private String osgiFrameworkVersion;
        private String modemImei;
        private String modemIccid;
        private String modemImsi;
        private String modemRssi;
        private String modemFirmwareVersion;
        private String payloadEncoding;
        private TamperStatus tamperStatus;
        private KuraPosition position;

        public KuraBirthPayloadBuilder withUptime(String uptime) {
            this.uptime = uptime;
            return this;
        }

        public KuraBirthPayloadBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public KuraBirthPayloadBuilder withAvailableProcessors(String availableProcessors) {
            this.availableProcessors = availableProcessors;
            return this;
        }

        public KuraBirthPayloadBuilder withTotalMemory(String totalMemory) {
            this.totalMemory = totalMemory;
            return this;
        }

        public KuraBirthPayloadBuilder withOsArch(String osArch) {
            this.osArch = osArch;
            return this;
        }

        public KuraBirthPayloadBuilder withOsgiFramework(String osgiFramework) {
            this.osgiFramework = osgiFramework;
            return this;
        }

        public KuraBirthPayloadBuilder withOsgiFrameworkVersion(String osgiFrameworkVersion) {
            this.osgiFrameworkVersion = osgiFrameworkVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withModelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public KuraBirthPayloadBuilder withModelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public KuraBirthPayloadBuilder withPartNumber(String partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public KuraBirthPayloadBuilder withSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public KuraBirthPayloadBuilder withFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withBiosVersion(String biosVersion) {
            this.biosVersion = biosVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withCpuVersion(String cpuVersion) {
            this.cpuVersion = cpuVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withOs(String os) {
            this.os = os;
            return this;
        }

        public KuraBirthPayloadBuilder withOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withJvmName(String jvmName) {
            this.jvmName = jvmName;
            return this;
        }

        public KuraBirthPayloadBuilder withJvmVersion(String jvmVersion) {
            this.jvmVersion = jvmVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withJvmProfile(String jvmProfile) {
            this.jvmProfile = jvmProfile;
            return this;
        }

        public KuraBirthPayloadBuilder withKuraVersion(String kuraVersion) {
            this.withApplicationFramework("Kura");
            this.withApplicationFrameworkVersion(kuraVersion);
            return this;
        }

        public KuraBirthPayloadBuilder withApplicationFramework(String applicationFramework) {
            this.applicationFramework = applicationFramework;
            return this;
        }

        public KuraBirthPayloadBuilder withApplicationFrameworkVersion(String applicationFrameworkVersion) {
            this.applicationFrameworkVersion = applicationFrameworkVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withConnectionInterface(String connectionInterface) {
            this.connectionInterface = connectionInterface;
            return this;
        }

        public KuraBirthPayloadBuilder withConnectionIp(String connectionIp) {
            this.connectionIp = connectionIp;
            return this;
        }

        public KuraBirthPayloadBuilder withAcceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public KuraBirthPayloadBuilder withApplicationIdentifiers(String applicationIdentifiers) {
            this.applicationIdentifiers = applicationIdentifiers;
            return this;
        }

        public KuraBirthPayloadBuilder withModemImei(String modemImei) {
            this.modemImei = modemImei;
            return this;
        }

        public KuraBirthPayloadBuilder withModemIccid(String modemIccid) {
            this.modemIccid = modemIccid;
            return this;
        }

        public KuraBirthPayloadBuilder withModemImsi(String modemImsi) {
            this.modemImsi = modemImsi;
            return this;
        }

        public KuraBirthPayloadBuilder withModemRssi(String modemRssi) {
            this.modemRssi = modemRssi;
            return this;
        }

        public KuraBirthPayloadBuilder withModemFirmwareVersion(String modemFirmwareVersion) {
            this.modemFirmwareVersion = modemFirmwareVersion;
            return this;
        }

        public KuraBirthPayloadBuilder withPosition(KuraPosition position) {
            this.position = position;
            return this;
        }

        public KuraBirthPayloadBuilder withPayloadEncoding(String payloadEncoding) {
            this.payloadEncoding = payloadEncoding;
            return this;
        }

        public KuraBirthPayloadBuilder withTamperStatus(TamperStatus tamperStatus) {
            this.tamperStatus = tamperStatus;
            return this;
        }

        public KuraBirthPayloadBuilder withJvmVendor(String jvmVendor) {
            this.jvmVendor = jvmVendor;
            return this;
        }

        public KuraBirthPayloadBuilder withJdkVendorVersion(String jdkVendorVersion) {
            this.jdkVendorVersion = Optional.ofNullable(jdkVendorVersion);
            return this;
        }

        public KuraBirthPayload build() {
            KuraBirthPayload birthPayload = new KuraBirthPayload();
            birthPayload.addMetric("uptime", this.uptime);
            birthPayload.addMetric("display_name", this.displayName);
            birthPayload.addMetric("model_name", this.modelName);
            birthPayload.addMetric("model_id", this.modelId);
            birthPayload.addMetric("part_number", this.partNumber);
            birthPayload.addMetric("serial_number", this.serialNumber);
            birthPayload.addMetric("firmware_version", this.firmwareVersion);
            birthPayload.addMetric("bios_version", this.biosVersion);
            birthPayload.addMetric("cpu_version", this.cpuVersion);
            birthPayload.addMetric("os", this.os);
            birthPayload.addMetric("os_version", this.osVersion);
            birthPayload.addMetric("jvm_name", this.jvmName);
            birthPayload.addMetric("jvm_version", this.jvmVersion);
            birthPayload.addMetric("jvm_profile", this.jvmProfile);
            birthPayload.addMetric("kura_version", this.kuraVersion);
            if (this.applicationFramework != null) {
                birthPayload.addMetric("application_framework", this.applicationFramework);
            } else {
                birthPayload.addMetric("application_framework", "Kura");
            }
            birthPayload.addMetric("kura_version", this.applicationFrameworkVersion);
            birthPayload.addMetric("application_framework_version", this.applicationFrameworkVersion);
            birthPayload.addMetric("connection_interface", this.connectionInterface);
            birthPayload.addMetric("connection_ip", this.connectionIp);
            birthPayload.addMetric(KuraBirthPayload.ACCEPT_ENCODING_KEY, this.acceptEncoding);
            birthPayload.addMetric(KuraBirthPayload.APPLICATION_IDS_KEY, this.applicationIdentifiers);
            birthPayload.addMetric("available_processors", this.availableProcessors);
            birthPayload.addMetric("total_memory", this.totalMemory);
            birthPayload.addMetric("os_arch", this.osArch);
            birthPayload.addMetric("osgi_framework", this.osgiFramework);
            birthPayload.addMetric("osgi_framework_version", this.osgiFrameworkVersion);
            birthPayload.addMetric(KuraBirthPayload.MODEM_IMEI_KEY, this.modemImei);
            birthPayload.addMetric(KuraBirthPayload.MODEM_ICCID_KEY, this.modemIccid);
            birthPayload.addMetric(KuraBirthPayload.MODEM_IMSI_KEY, this.modemImsi);
            birthPayload.addMetric(KuraBirthPayload.MODEM_RSSI_KEY, this.modemRssi);
            birthPayload.addMetric(KuraBirthPayload.MODEM_FIRMWARE_VERSION, this.modemFirmwareVersion);
            birthPayload.addMetric(KuraBirthPayload.PAYLOAD_ENCODING_KEY, this.payloadEncoding);
            if (this.tamperStatus != null && this.tamperStatus != TamperStatus.UNSUPPORTED) {
                birthPayload.addMetric(KuraBirthPayload.TAMPER_STATUS, this.tamperStatus.name());
            }
            birthPayload.setPosition(this.position);
            birthPayload.addMetric("jvm_vendor", this.jvmVendor);
            if (this.jdkVendorVersion.isPresent()) {
                birthPayload.addMetric("jdk_vendor_version", this.jdkVendorVersion.get());
            }
            return birthPayload;
        }
    }

    public static enum TamperStatus {
        UNSUPPORTED,
        TAMPERED,
        NOT_TAMPERED;

    }
}

