/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class BooleanValue
implements TypedValue<Boolean> {
    private final boolean value;

    public BooleanValue(boolean value) {
        this.value = value;
    }

    @Override
    public int compareTo(TypedValue<Boolean> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        return this.value == otherTypedValue.getValue() ? 0 : (this.value ? 1 : -1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanValue other = (BooleanValue)obj;
        return this.value == other.value;
    }

    @Override
    public DataType getType() {
        return DataType.BOOLEAN;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return "BooleanValue [value=" + this.value + "]";
    }
}

