/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.provider.helper;

import java.util.HashMap;
import org.eclipse.kura.asset.provider.AssetConstants;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ScaleOffsetType;
import org.eclipse.kura.type.DataType;

public class ChannelRecordHelper {
    private ChannelRecordHelper() {
    }

    public static ChannelRecord createModifiedChannelRecord(Channel channel) {
        DataType actualDataType = channel.getScaleOffsetType() == ScaleOffsetType.DEFINED_BY_VALUE_TYPE ? channel.getValueType() : ChannelRecordHelper.toDataType(channel.getScaleOffsetType());
        ChannelRecord channelRecord = ChannelRecord.createReadRecord((String)channel.getName(), (DataType)actualDataType, (String)channel.getUnit());
        HashMap<String, String> configMap = new HashMap<String, String>(channel.getConfiguration());
        configMap.put(AssetConstants.VALUE_TYPE.value(), actualDataType.name());
        channelRecord.setChannelConfig(configMap);
        return channelRecord;
    }

    private static DataType toDataType(ScaleOffsetType scaleOffsetType) {
        switch (scaleOffsetType) {
            case DOUBLE: {
                return DataType.DOUBLE;
            }
            case LONG: {
                return DataType.LONG;
            }
        }
        throw new IllegalArgumentException("Unsupported scale offset type: " + scaleOffsetType);
    }
}

