package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ContainerMount}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContainerMount.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableContainerMount implements ContainerMount {
  private final @Nullable String type;
  private final @Nullable String name;
  private final String source;
  private final String destination;
  private final @Nullable String driver;
  private final String mode;
  private final Boolean rw;
  private final @Nullable String propagation;

  private ImmutableContainerMount(
      @Nullable String type,
      @Nullable String name,
      String source,
      String destination,
      @Nullable String driver,
      String mode,
      Boolean rw,
      @Nullable String propagation) {
    this.type = type;
    this.name = name;
    this.source = source;
    this.destination = destination;
    this.driver = driver;
    this.mode = mode;
    this.rw = rw;
    this.propagation = propagation;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("Type")
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("Name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("Source")
  @Override
  public String source() {
    return source;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @JsonProperty("Destination")
  @Override
  public String destination() {
    return destination;
  }

  /**
   * @return The value of the {@code driver} attribute
   */
  @JsonProperty("Driver")
  @Override
  public @Nullable String driver() {
    return driver;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @JsonProperty("Mode")
  @Override
  public String mode() {
    return mode;
  }

  /**
   * @return The value of the {@code rw} attribute
   */
  @JsonProperty("RW")
  @Override
  public Boolean rw() {
    return rw;
  }

  /**
   * @return The value of the {@code propagation} attribute
   */
  @JsonProperty("Propagation")
  @Override
  public @Nullable String propagation() {
    return propagation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableContainerMount(
        value,
        this.name,
        this.source,
        this.destination,
        this.driver,
        this.mode,
        this.rw,
        this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableContainerMount(
        this.type,
        value,
        this.source,
        this.destination,
        this.driver,
        this.mode,
        this.rw,
        this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#source() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableContainerMount(
        this.type,
        this.name,
        newValue,
        this.destination,
        this.driver,
        this.mode,
        this.rw,
        this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#destination() destination} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withDestination(String value) {
    String newValue = Objects.requireNonNull(value, "destination");
    if (this.destination.equals(newValue)) return this;
    return new ImmutableContainerMount(this.type, this.name, this.source, newValue, this.driver, this.mode, this.rw, this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#driver() driver} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for driver (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withDriver(@Nullable String value) {
    if (Objects.equals(this.driver, value)) return this;
    return new ImmutableContainerMount(
        this.type,
        this.name,
        this.source,
        this.destination,
        value,
        this.mode,
        this.rw,
        this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#mode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mode
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withMode(String value) {
    String newValue = Objects.requireNonNull(value, "mode");
    if (this.mode.equals(newValue)) return this;
    return new ImmutableContainerMount(
        this.type,
        this.name,
        this.source,
        this.destination,
        this.driver,
        newValue,
        this.rw,
        this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#rw() rw} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rw
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withRw(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "rw");
    if (this.rw.equals(newValue)) return this;
    return new ImmutableContainerMount(
        this.type,
        this.name,
        this.source,
        this.destination,
        this.driver,
        this.mode,
        newValue,
        this.propagation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerMount#propagation() propagation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propagation (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerMount withPropagation(@Nullable String value) {
    if (Objects.equals(this.propagation, value)) return this;
    return new ImmutableContainerMount(this.type, this.name, this.source, this.destination, this.driver, this.mode, this.rw, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContainerMount} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContainerMount
        && equalsByValue((ImmutableContainerMount) another);
  }

  private boolean equalsByValue(ImmutableContainerMount another) {
    return Objects.equals(type, another.type)
        && Objects.equals(name, another.name)
        && source.equals(another.source)
        && destination.equals(another.destination)
        && Objects.equals(driver, another.driver)
        && mode.equals(another.mode)
        && rw.equals(another.rw)
        && Objects.equals(propagation, another.propagation);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code name}, {@code source}, {@code destination}, {@code driver}, {@code mode}, {@code rw}, {@code propagation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + source.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + Objects.hashCode(driver);
    h += (h << 5) + mode.hashCode();
    h += (h << 5) + rw.hashCode();
    h += (h << 5) + Objects.hashCode(propagation);
    return h;
  }

  /**
   * Prints the immutable value {@code ContainerMount} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContainerMount{"
        + "type=" + type
        + ", name=" + name
        + ", source=" + source
        + ", destination=" + destination
        + ", driver=" + driver
        + ", mode=" + mode
        + ", rw=" + rw
        + ", propagation=" + propagation
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ContainerMount} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContainerMount instance
   */
  public static ImmutableContainerMount copyOf(ContainerMount instance) {
    if (instance instanceof ImmutableContainerMount) {
      return (ImmutableContainerMount) instance;
    }
    return ImmutableContainerMount.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContainerMount ImmutableContainerMount}.
   * <pre>
   * ImmutableContainerMount.builder()
   *    .type(String | null) // nullable {@link ContainerMount#type() type}
   *    .name(String | null) // nullable {@link ContainerMount#name() name}
   *    .source(String) // required {@link ContainerMount#source() source}
   *    .destination(String) // required {@link ContainerMount#destination() destination}
   *    .driver(String | null) // nullable {@link ContainerMount#driver() driver}
   *    .mode(String) // required {@link ContainerMount#mode() mode}
   *    .rw(Boolean) // required {@link ContainerMount#rw() rw}
   *    .propagation(String | null) // nullable {@link ContainerMount#propagation() propagation}
   *    .build();
   * </pre>
   * @return A new ImmutableContainerMount builder
   */
  public static ImmutableContainerMount.Builder builder() {
    return new ImmutableContainerMount.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContainerMount ImmutableContainerMount}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private static final long INIT_BIT_MODE = 0x4L;
    private static final long INIT_BIT_RW = 0x8L;
    private long initBits = 0xfL;

    private String type;
    private String name;
    private String source;
    private String destination;
    private String driver;
    private String mode;
    private Boolean rw;
    private String propagation;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContainerMount} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContainerMount instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String typeValue = instance.type();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      this.source(instance.source());
      this.destination(instance.destination());
      @Nullable String driverValue = instance.driver();
      if (driverValue != null) {
        driver(driverValue);
      }
      this.mode(instance.mode());
      this.rw(instance.rw());
      @Nullable String propagationValue = instance.propagation();
      if (propagationValue != null) {
        propagation(propagationValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Destination")
    public final Builder destination(String destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#driver() driver} attribute.
     * @param driver The value for driver (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Driver")
    public final Builder driver(@Nullable String driver) {
      this.driver = driver;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#mode() mode} attribute.
     * @param mode The value for mode 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Mode")
    public final Builder mode(String mode) {
      this.mode = Objects.requireNonNull(mode, "mode");
      initBits &= ~INIT_BIT_MODE;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#rw() rw} attribute.
     * @param rw The value for rw 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("RW")
    public final Builder rw(Boolean rw) {
      this.rw = Objects.requireNonNull(rw, "rw");
      initBits &= ~INIT_BIT_RW;
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerMount#propagation() propagation} attribute.
     * @param propagation The value for propagation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Propagation")
    public final Builder propagation(@Nullable String propagation) {
      this.propagation = propagation;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContainerMount ImmutableContainerMount}.
     * @return An immutable instance of ContainerMount
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContainerMount build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContainerMount(type, name, source, destination, driver, mode, rw, propagation);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      if ((initBits & INIT_BIT_MODE) != 0) attributes.add("mode");
      if ((initBits & INIT_BIT_RW) != 0) attributes.add("rw");
      return "Cannot build ContainerMount, some of required attributes are not set " + attributes;
    }
  }
}
