/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.tools.launch.core.factory.CdtSpawnerProcessFactory;

public class STNM {
    private static final Pattern UNDEF_PATTERN = Pattern.compile("^\\s+U\\s+(\\S+)");
    private static final Pattern NORMAL_PATTERN = Pattern.compile("^(\\S+)\\s+([AaTtBbDd])\\s+(\\S+)");
    private final STNMSymbolsHandler handler;

    public STNM(String command, String[] params, String file, STNMSymbolsHandler handler, IProject project) throws IOException {
        this.handler = handler;
        if (handler != null) {
            this.init(command, params, file, project);
        }
    }

    private void init(String command, String[] params, String file, IProject project) throws IOException {
        String[] args = null;
        if (params == null || params.length == 0) {
            args = new String[]{command, file};
        } else {
            args = new String[params.length + 2];
            args[0] = command;
            args[params.length + 1] = file;
            System.arraycopy(params, 0, args, 1, params.length);
        }
        Process process = CdtSpawnerProcessFactory.getFactory().exec(args, project);
        this.parseOutput(process.inputReader());
        process.destroy();
    }

    private void parseOutput(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            Matcher undef_matcher = UNDEF_PATTERN.matcher(line);
            Matcher normal_matcher = NORMAL_PATTERN.matcher(line);
            try {
                if (undef_matcher.matches()) {
                    this.handler.foundUndefSymbol(undef_matcher.group(1));
                    continue;
                }
                if (!normal_matcher.matches()) continue;
                char type = normal_matcher.group(2).charAt(0);
                String name = normal_matcher.group(3);
                String address = normal_matcher.group(1);
                switch (type) {
                    case 'T': 
                    case 't': {
                        this.handler.foundTextSymbol(name, address);
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.handler.foundBssSymbol(name, address);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        this.handler.foundDataSymbol(name, address);
                    }
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
        }
    }
}

