/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.algebra;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;

public class SparseMatrix
extends Matrix {
    private int rows;
    private int columns;
    private Map<Tuple<Integer, Integer>, Value> valueMap;

    public SparseMatrix(int rows, int columns) {
        this.columns = columns;
        this.rows = rows;
        this.valueMap = new HashMap<Tuple<Integer, Integer>, Value>();
    }

    @Override
    public void put(int row, int column, Value value) {
        this.valueMap.put(Tuple.of(row, column), value);
    }

    @Override
    public Value get(int row, int column) {
        Tuple<Integer, Integer> index = Tuple.of(row, column);
        if (this.valueMap.containsKey(index)) {
            return this.valueMap.get(index);
        }
        if (row == column) {
            return new Value(0.0);
        }
        return Value.NEGATIVE_INFINITY;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.rows) {
            sb.append("| ");
            int j = 0;
            while (j < this.columns) {
                sb.append(this.get(i, j).toString());
                sb.append("\t");
                ++j;
            }
            sb.append("|\n");
            ++i;
        }
        return sb.toString();
    }
}

