/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.model;

import com.google.gson.annotations.SerializedName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.lsat.external.api.model.ActionBase;
import org.eclipse.lsat.external.api.model.ActivityDependency;
import org.eclipse.lsat.external.api.model.LsatBase;

public class Activity
extends LsatBase {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    @Nullable
    private Map<String, ActionBase> actions = new LinkedHashMap<String, ActionBase>();
    public static final String SERIALIZED_NAME_DEPENDENCIES = "dependencies";
    @SerializedName(value="dependencies")
    @Nullable
    private List<ActivityDependency> dependencies = new ArrayList<ActivityDependency>();

    public Activity name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Activity actions(@Nullable Map<String, ActionBase> actions) {
        this.actions = actions;
        return this;
    }

    public Activity putActionsItem(String key, ActionBase actionsItem) {
        if (this.actions == null) {
            this.actions = new LinkedHashMap<String, ActionBase>();
        }
        this.actions.put(key, actionsItem);
        return this;
    }

    @Nullable
    public Map<String, ActionBase> getActions() {
        return this.actions;
    }

    public void setActions(@Nullable Map<String, ActionBase> actions) {
        this.actions = actions;
    }

    public Activity dependencies(@Nullable List<ActivityDependency> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public Activity addDependenciesItem(ActivityDependency dependenciesItem) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ActivityDependency>();
        }
        this.dependencies.add(dependenciesItem);
        return this;
    }

    @Nullable
    public List<ActivityDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(@Nullable List<ActivityDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals(this.name, activity.name) && Objects.equals(this.actions, activity.actions) && Objects.equals(this.dependencies, activity.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.actions, this.dependencies);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Activity {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    dependencies: ").append(this.toIndentedString(this.dependencies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

