/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.activity.diagram.design;

import activity.ActivityFactory;
import activity.ActivitySet;
import activity.Event;
import activity.EventAction;
import activity.RaiseEvent;
import common.HasName;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import machine.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddEventActionPage
extends WizardPage {
    private final String initialActionName;
    private final Collection<EObject> roots;
    private Text textName;
    private Text newEventName;
    private ComboViewer comboEventType;
    private ComboViewer comboEventResource;

    public AddEventActionPage(Collection<EObject> roots, String initialActionName) {
        super(AddEventActionPage.class.getSimpleName());
        this.roots = roots;
        this.setTitle("EventAction details");
        this.setDescription("Provide the details for the event to add");
        this.initialActionName = initialActionName;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblName = new Label(container, 0);
        lblName.setAlignment(131072);
        lblName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblName.setText("Action Name:");
        this.textName = new Text(container, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textName.setText(this.initialActionName);
        Label evtName = new Label(container, 0);
        evtName.setAlignment(131072);
        evtName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        evtName.setText("Select Event :");
        this.comboEventResource = new ComboViewer(container, 0);
        this.comboEventResource.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboEventResource.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IResource)element).fqn();
            }
        });
        this.comboEventResource.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboEventResource.getCombo().setEnabled(true);
        this.comboEventResource.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEventActionPage.this.updatePageComplete();
            }
        });
        List eventResources = this.roots.stream().filter(ActivitySet.class::isInstance).map(ActivitySet.class::cast).flatMap(m -> m.getEvents().stream()).flatMap(r -> Stream.concat(Stream.of(r), r.getResource().getItems().stream())).map(IResource.class::cast).sorted((r1, r2) -> r1.fqn().compareTo(r2.fqn())).collect(Collectors.toList());
        Event newEvent = ActivityFactory.eINSTANCE.createEvent();
        newEvent.setName("NEW EVENT");
        eventResources.add(0, newEvent);
        this.comboEventResource.setInput(eventResources);
        Label lblEventName = new Label(container, 0);
        lblEventName.setAlignment(131072);
        lblEventName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblEventName.setText("Add New Event:");
        this.newEventName = new Text(container, 2048);
        this.newEventName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.newEventName.setText("");
        Label lblType = new Label(container, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText("EventAction type:");
        this.comboEventType = new ComboViewer(container, 0);
        this.comboEventType.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboEventType.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboEventType.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboEventType.getCombo().setEnabled(true);
        this.comboEventType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEventActionPage.this.updatePageComplete();
            }
        });
        this.comboEventType.setInput((Object)EventType.values());
    }

    public EventAction createEventAction() {
        String actionName = this.textName.getText();
        String newEvent = this.newEventName.getText();
        EventType type = (EventType)((Object)((StructuredSelection)this.comboEventType.getSelection()).getFirstElement());
        RaiseEvent eventAction = type == EventType.Raise ? ActivityFactory.eINSTANCE.createRaiseEvent() : ActivityFactory.eINSTANCE.createRequireEvent();
        IResource resource = (IResource)((StructuredSelection)this.comboEventResource.getSelection()).getFirstElement();
        if ("NEW EVENT".equals(resource.getName()) && resource instanceof HasName) {
            HasName hasName = (HasName)resource;
            hasName.setName(newEvent);
        }
        eventAction.setName(actionName);
        eventAction.setResource(resource);
        return eventAction;
    }

    private void updatePageComplete() {
        boolean pageComplete = true;
        boolean eventResourceSelected = !this.comboEventResource.getSelection().isEmpty();
        pageComplete &= !this.textName.getText().isEmpty();
        pageComplete &= eventResourceSelected;
        pageComplete &= !this.comboEventType.getSelection().isEmpty();
        if (eventResourceSelected) {
            IResource resource = (IResource)((StructuredSelection)this.comboEventResource.getSelection()).getFirstElement();
            if ("NEW EVENT".equals(resource.getName())) {
                this.newEventName.setEditable(true);
                pageComplete &= !this.newEventName.getText().isEmpty();
            } else {
                this.newEventName.setEditable(false);
            }
        }
        this.setPageComplete(pageComplete);
    }

    private static enum EventType {
        Require("Require event"),
        Raise("Raise event");

        private final String description;

        private EventType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

