/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.serializer;

import activity.Activity;
import activity.ActivityPackage;
import activity.ActivitySet;
import activity.Claim;
import activity.ConstraintEdge;
import activity.Dependency;
import activity.Event;
import activity.EventItem;
import activity.JitBounds;
import activity.LocationPrerequisite;
import activity.ModelTypeDefinitionRef;
import activity.Move;
import activity.ProductChange;
import activity.RaiseEvent;
import activity.Release;
import activity.RequireEvent;
import activity.SimpleAction;
import activity.TimeBounds;
import activity.TracePoint;
import com.google.inject.Inject;
import common.CommonPackage;
import common.Import;
import common.ParameterDeclaration;
import java.util.Set;
import machine.ActionType;
import machine.Distance;
import machine.MachinePackage;
import machine.Profile;
import machine.Resource;
import machine.SymbolicPosition;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;
import org.eclipse.lsat.common.graph.directed.editable.EdgPackage;
import org.eclipse.lsat.common.graph.directed.editable.SourceReference;
import org.eclipse.lsat.common.graph.directed.editable.TargetReference;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import product.BooleanValue;
import product.IntegerValue;
import product.ProductPackage;
import product.Property;
import product.StringValue;

@SuppressWarnings("all")
public abstract class AbstractActivitySemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private ActivityGrammarAccess grammarAccess;

    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == ActivityPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case ActivityPackage.ACTIVITY:
                sequence_Activity(context, (Activity) semanticObject); 
                return; 
            case ActivityPackage.ACTIVITY_SET:
                sequence_ActivitySet(context, (ActivitySet) semanticObject); 
                return; 
            case ActivityPackage.CLAIM:
                sequence_Claim(context, (Claim) semanticObject); 
                return; 
            case ActivityPackage.CONSTRAINT_EDGE:
                if (rule == grammarAccess.getEdgeWithInfiniteTimeConstraintRule()) {
                    sequence_EdgeWithInfiniteTimeConstraint(context, (ConstraintEdge) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getEdgesWithConstraintsRule()) {
                    sequence_EdgeWithInfiniteTimeConstraint_EdgeWithJitConstraint_EdgeWithTimeConstraint(context, (ConstraintEdge) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getEdgeWithJitConstraintRule()) {
                    sequence_EdgeWithJitConstraint(context, (ConstraintEdge) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getEdgeWithTimeConstraintRule()) {
                    sequence_EdgeWithTimeConstraint(context, (ConstraintEdge) semanticObject); 
                    return; 
                }
                else break;
            case ActivityPackage.DEPENDENCY:
                if (rule == grammarAccess.getEdgeRule()) {
                    sequence_Edge(context, (Dependency) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getEdgesRule()
                		|| rule == grammarAccess.getDependencyTargetRule()) {
                    sequence_Edge_JitConstraintEdge_TimeConstraintEdge(context, (Dependency) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getJitConstraintEdgeRule()) {
                    sequence_JitConstraintEdge(context, (Dependency) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getTimeConstraintEdgeRule()) {
                    sequence_TimeConstraintEdge(context, (Dependency) semanticObject); 
                    return; 
                }
                else break;
            case ActivityPackage.EVENT:
                if (rule == grammarAccess.getEventDefRule()) {
                    sequence_EventDef(context, (Event) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getEventRule()) {
                    sequence_Event(context, (Event) semanticObject); 
                    return; 
                }
                else break;
            case ActivityPackage.EVENT_ITEM:
                sequence_EventItem(context, (EventItem) semanticObject); 
                return; 
            case ActivityPackage.JIT_BOUNDS:
                sequence_JitConstraint(context, (JitBounds) semanticObject); 
                return; 
            case ActivityPackage.LOCATION_PREREQUISITE:
                sequence_LocationPrerequisite(context, (LocationPrerequisite) semanticObject); 
                return; 
            case ActivityPackage.MODEL_TYPE_DEFINITION_REF:
                sequence_ModelTypeDefinitionRef(context, (ModelTypeDefinitionRef) semanticObject); 
                return; 
            case ActivityPackage.MOVE:
                sequence_Move(context, (Move) semanticObject); 
                return; 
            case ActivityPackage.PRODUCT_CHANGE:
                if (rule == grammarAccess.getProductChangeNoTransferTypeRule()) {
                    sequence_ProductChangeNoTransferType(context, (ProductChange) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getProductChangeRule()) {
                    sequence_ProductChangeNoTransferType_ProductChangeWithTransferType(context, (ProductChange) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getProductChangeWithTransferTypeRule()) {
                    sequence_ProductChangeWithTransferType(context, (ProductChange) semanticObject); 
                    return; 
                }
                else break;
            case ActivityPackage.RAISE_EVENT:
                sequence_RaiseEvent(context, (RaiseEvent) semanticObject); 
                return; 
            case ActivityPackage.RELEASE:
                sequence_Release(context, (Release) semanticObject); 
                return; 
            case ActivityPackage.REQUIRE_EVENT:
                sequence_RequireEvent(context, (RequireEvent) semanticObject); 
                return; 
            case ActivityPackage.SIMPLE_ACTION:
                sequence_SimpleAction(context, (SimpleAction) semanticObject); 
                return; 
            case ActivityPackage.TIME_BOUNDS:
                if (rule == grammarAccess.getInfiniteTimeConstraintRule()) {
                    sequence_InfiniteTimeConstraint(context, (TimeBounds) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getTimeConstraintRule()) {
                    sequence_TimeConstraint(context, (TimeBounds) semanticObject); 
                    return; 
                }
                else break;
            case ActivityPackage.TRACE_POINT:
                sequence_TracePoint(context, (TracePoint) semanticObject); 
                return; 
            }
        else if (epackage == CommonPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case CommonPackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            case CommonPackage.PARAMETER_DECLARATION:
                if (rule == grammarAccess.getParameterDeclarationRule()) {
                    sequence_ActionDeclaration_DistanceDeclaration_EventDeclaration_ModelTypeDefinitionRefDeclaration_ProfileDeclaration_ResourceDeclaration_SymbolicPositionDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getActionDeclarationRule()) {
                    sequence_ActionDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getDistanceDeclarationRule()) {
                    sequence_DistanceDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getEventDeclarationRule()) {
                    sequence_EventDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getModelTypeDefinitionRefDeclarationRule()) {
                    sequence_ModelTypeDefinitionRefDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getProfileDeclarationRule()) {
                    sequence_ProfileDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getResourceDeclarationRule()) {
                    sequence_ResourceDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else if (rule == grammarAccess.getSymbolicPositionDeclarationRule()) {
                    sequence_SymbolicPositionDeclaration(context, (ParameterDeclaration) semanticObject); 
                    return; 
                }
                else break;
            }
        else if (epackage == EdgPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case EdgPackage.SOURCE_REFERENCE:
                sequence_SourceReference(context, (SourceReference) semanticObject); 
                return; 
            case EdgPackage.TARGET_REFERENCE:
                sequence_TargetReference(context, (TargetReference) semanticObject); 
                return; 
            }
        else if (epackage == MachinePackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case MachinePackage.ACTION_TYPE:
                sequence_ActionDef(context, (ActionType) semanticObject); 
                return; 
            case MachinePackage.DISTANCE:
                sequence_DistanceDef(context, (Distance) semanticObject); 
                return; 
            case MachinePackage.PROFILE:
                sequence_ProfileDef(context, (Profile) semanticObject); 
                return; 
            case MachinePackage.RESOURCE:
                sequence_ResourceDef(context, (Resource) semanticObject); 
                return; 
            case MachinePackage.SYMBOLIC_POSITION:
                sequence_SymbolicPositionDef(context, (SymbolicPosition) semanticObject); 
                return; 
            }
        else if (epackage == ProductPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case ProductPackage.BOOLEAN_VALUE:
                sequence_BooleanValue(context, (BooleanValue) semanticObject); 
                return; 
            case ProductPackage.INTEGER_VALUE:
                sequence_IntegerValue(context, (IntegerValue) semanticObject); 
                return; 
            case ProductPackage.PROPERTY:
                sequence_Property(context, (Property) semanticObject); 
                return; 
            case ProductPackage.STRING_VALUE:
                sequence_StringValue(context, (StringValue) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }

    /**
     * <pre>
     * Contexts:
     *     ParameterDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (
     *         (declarations+=EventDef declarations+=EventDef*) | 
     *         (declarations+=ActionDef declarations+=ActionDef*) | 
     *         (declarations+=SymbolicPositionDef declarations+=SymbolicPositionDef*) | 
     *         (declarations+=ProfileDef declarations+=ProfileDef*) | 
     *         (declarations+=DistanceDef declarations+=DistanceDef*) | 
     *         (declarations+=ResourceDef declarations+=ResourceDef*) | 
     *         declarations+=ModelTypeDefinitionRef
     *     )
     * </pre>
     */
                protected void sequence_ActionDeclaration_DistanceDeclaration_EventDeclaration_ModelTypeDefinitionRefDeclaration_ProfileDeclaration_ResourceDeclaration_SymbolicPositionDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ActionDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (declarations+=ActionDef declarations+=ActionDef*)
     * </pre>
     */
                protected void sequence_ActionDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ActionDef returns ActionType
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_ActionDef(ISerializationContext context, ActionType semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getActionDefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     ActivitySet returns ActivitySet
     *
     * Constraint:
     *     (imports+=Import* (activities+=Activity | events+=Event)*)
     * </pre>
     */
                protected void sequence_ActivitySet(ISerializationContext context, ActivitySet semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Activity returns Activity
     *
     * Constraint:
     *     (
     *         name=ID 
     *         parameterDeclarations+=ParameterDeclaration? 
     *         parameterDeclarations+=ParameterDeclaration* 
     *         prerequisites+=LocationPrerequisite* 
     *         nodes+=Node* 
     *         edges+=Edges* 
     *         constraints+=EdgesWithConstraints*
     *     )
     * </pre>
     */
                protected void sequence_Activity(ISerializationContext context, Activity semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     BooleanValue returns BooleanValue
     *
     * Constraint:
     *     value=BooleanLiteral
     * </pre>
     */
                protected void sequence_BooleanValue(ISerializationContext context, BooleanValue semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ProductPackage.Literals.BOOLEAN_VALUE__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ProductPackage.Literals.BOOLEAN_VALUE__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getBooleanValueAccess().getValueBooleanLiteralParserRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns Claim
     *     Claim returns Claim
     *
     * Constraint:
     *     (
     *         name=ID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         passive?='passive'? 
     *         resourceDefinition=[Resource|ID] 
     *         resourceItem=[ResourceItem|IID]? 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_Claim(ISerializationContext context, Claim semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     DistanceDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (declarations+=DistanceDef declarations+=DistanceDef*)
     * </pre>
     */
                protected void sequence_DistanceDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     DistanceDef returns Distance
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_DistanceDef(ISerializationContext context, Distance semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getDistanceDefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     EdgeWithInfiniteTimeConstraint returns ConstraintEdge
     *
     * Constraint:
     *     (source=[ResourceAction|IID] bounds=InfiniteTimeConstraint target=[ResourceAction|IID])
     * </pre>
     */
                protected void sequence_EdgeWithInfiniteTimeConstraint(ISerializationContext context, ConstraintEdge semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__BOUNDS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__BOUNDS));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getSourceResourceActionIIDParserRuleCall_1_0_1(), semanticObject.eGet(ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE, false));
    feeder.accept(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getBoundsInfiniteTimeConstraintParserRuleCall_3_0(), semanticObject.getBounds());
    feeder.accept(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getTargetResourceActionIIDParserRuleCall_4_0_1(), semanticObject.eGet(ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     EdgesWithConstraints returns ConstraintEdge
     *
     * Constraint:
     *     (
     *         (source=[ResourceAction|IID] bounds=JitConstraint target=[ResourceAction|IID]) | 
     *         (source=[ResourceAction|IID] bounds=TimeConstraint target=[ResourceAction|IID]) | 
     *         (source=[ResourceAction|IID] bounds=InfiniteTimeConstraint target=[ResourceAction|IID])
     *     )
     * </pre>
     */
                protected void sequence_EdgeWithInfiniteTimeConstraint_EdgeWithJitConstraint_EdgeWithTimeConstraint(ISerializationContext context, ConstraintEdge semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     EdgeWithJitConstraint returns ConstraintEdge
     *
     * Constraint:
     *     (source=[ResourceAction|IID] bounds=JitConstraint target=[ResourceAction|IID])
     * </pre>
     */
                protected void sequence_EdgeWithJitConstraint(ISerializationContext context, ConstraintEdge semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__BOUNDS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__BOUNDS));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEdgeWithJitConstraintAccess().getSourceResourceActionIIDParserRuleCall_1_0_1(), semanticObject.eGet(ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE, false));
    feeder.accept(grammarAccess.getEdgeWithJitConstraintAccess().getBoundsJitConstraintParserRuleCall_3_0(), semanticObject.getBounds());
    feeder.accept(grammarAccess.getEdgeWithJitConstraintAccess().getTargetResourceActionIIDParserRuleCall_4_0_1(), semanticObject.eGet(ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     EdgeWithTimeConstraint returns ConstraintEdge
     *
     * Constraint:
     *     (source=[ResourceAction|IID] bounds=TimeConstraint target=[ResourceAction|IID])
     * </pre>
     */
                protected void sequence_EdgeWithTimeConstraint(ISerializationContext context, ConstraintEdge semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__BOUNDS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__BOUNDS));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEdgeWithTimeConstraintAccess().getSourceResourceActionIIDParserRuleCall_1_0_1(), semanticObject.eGet(ActivityPackage.Literals.CONSTRAINT_EDGE__SOURCE, false));
    feeder.accept(grammarAccess.getEdgeWithTimeConstraintAccess().getBoundsTimeConstraintParserRuleCall_3_0(), semanticObject.getBounds());
    feeder.accept(grammarAccess.getEdgeWithTimeConstraintAccess().getTargetResourceActionIIDParserRuleCall_5_0_1(), semanticObject.eGet(ActivityPackage.Literals.CONSTRAINT_EDGE__TARGET, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Edge returns Dependency
     *
     * Constraint:
     *     (source=SourceReference target=DependencyTarget)
     * </pre>
     */
                protected void sequence_Edge(ISerializationContext context, Dependency semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0(), semanticObject.getSource());
    feeder.accept(grammarAccess.getEdgeAccess().getTargetDependencyTargetParserRuleCall_3_0(), semanticObject.getTarget());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Edges returns Dependency
     *     DependencyTarget returns Dependency
     *
     * Constraint:
     *     (
     *         (source=SourceReference target=DependencyTarget) | 
     *         (source=SourceReference bounds=JitConstraint target=DependencyTarget) | 
     *         (source=SourceReference bounds=TimeConstraint target=DependencyTarget)
     *     )
     * </pre>
     */
                protected void sequence_Edge_JitConstraintEdge_TimeConstraintEdge(ISerializationContext context, Dependency semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     EventDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (declarations+=EventDef declarations+=EventDef*)
     * </pre>
     */
                protected void sequence_EventDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     EventDef returns Event
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_EventDef(ISerializationContext context, Event semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEventDefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     EventItem returns EventItem
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_EventItem(ISerializationContext context, EventItem semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getEventItemAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Event returns Event
     *
     * Constraint:
     *     (name=ID (items+=EventItem items+=EventItem*)?)
     * </pre>
     */
                protected void sequence_Event(ISerializationContext context, Event semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     * </pre>
     */
                protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     InfiniteTimeConstraint returns TimeBounds
     *
     * Constraint:
     *     {TimeBounds}
     * </pre>
     */
                protected void sequence_InfiniteTimeConstraint(ISerializationContext context, TimeBounds semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     IntegerValue returns IntegerValue
     *
     * Constraint:
     *     value=INT
     * </pre>
     */
                protected void sequence_IntegerValue(ISerializationContext context, IntegerValue semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ProductPackage.Literals.INTEGER_VALUE__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ProductPackage.Literals.INTEGER_VALUE__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getIntegerValueAccess().getValueINTTerminalRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     JitConstraintEdge returns Dependency
     *
     * Constraint:
     *     (source=SourceReference bounds=JitConstraint target=DependencyTarget)
     * </pre>
     */
                protected void sequence_JitConstraintEdge(ISerializationContext context, Dependency semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.DEPENDENCY__BOUNDS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.DEPENDENCY__BOUNDS));
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getJitConstraintEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0(), semanticObject.getSource());
    feeder.accept(grammarAccess.getJitConstraintEdgeAccess().getBoundsJitConstraintParserRuleCall_3_0(), semanticObject.getBounds());
    feeder.accept(grammarAccess.getJitConstraintEdgeAccess().getTargetDependencyTargetParserRuleCall_4_0(), semanticObject.getTarget());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     JitConstraint returns JitBounds
     *
     * Constraint:
     *     {JitBounds}
     * </pre>
     */
                protected void sequence_JitConstraint(ISerializationContext context, JitBounds semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     LocationPrerequisite returns LocationPrerequisite
     *
     * Constraint:
     *     (resourceDefinition=[Resource|ID] resourceItem=[ResourceItem|IID]? peripheral=[Peripheral|ID] position=[SymbolicPosition|ID])
     * </pre>
     */
                protected void sequence_LocationPrerequisite(ISerializationContext context, LocationPrerequisite semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ModelTypeDefinitionRefDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     declarations+=ModelTypeDefinitionRef
     * </pre>
     */
                protected void sequence_ModelTypeDefinitionRefDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ModelTypeDefinitionRef returns ModelTypeDefinitionRef
     *
     * Constraint:
     *     (name=ID typeDefinition=[TypeDefinition|ID])
     * </pre>
     */
                protected void sequence_ModelTypeDefinitionRef(ISerializationContext context, ModelTypeDefinitionRef semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.MODEL_TYPE_DEFINITION_REF__TYPE_DEFINITION) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.MODEL_TYPE_DEFINITION_REF__TYPE_DEFINITION));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getModelTypeDefinitionRefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.accept(grammarAccess.getModelTypeDefinitionRefAccess().getTypeDefinitionTypeDefinitionIDTerminalRuleCall_3_0_1(), semanticObject.eGet(ActivityPackage.Literals.MODEL_TYPE_DEFINITION_REF__TYPE_DEFINITION, false));
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns Move
     *     Move returns Move
     *
     * Constraint:
     *     (
     *         name=ID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         resourceDefinition=[Resource|ID] 
     *         resourceItem=[ResourceItem|IID]? 
     *         peripheral=[Peripheral|ID] 
     *         ((passing?='passing'? targetPosition=[SymbolicPosition|ID]) | (continuing?='continuing'? distance=[Distance|ID])) 
     *         profile=[Profile|ID] 
     *         schedulingType=Scheduling? 
     *         (productChanges+=ProductChange productChanges+=ProductChangeWithTransferType*)? 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_Move(ISerializationContext context, Move semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ProductChangeNoTransferType returns ProductChange
     *
     * Constraint:
     *     (
     *         (
     *             product=[ProductDefinition|ID] 
     *             slot=IID? 
     *             (startProperties+=Property startProperties+=Property*)? 
     *             (endProperties+=Property endProperties+=Property*)?
     *         ) | 
     *         (slot=IID (startProperties+=Property startProperties+=Property*)? (endProperties+=Property endProperties+=Property*)?) | 
     *         (startProperties+=Property startProperties+=Property* (endProperties+=Property endProperties+=Property*)?) | 
     *         (endProperties+=Property endProperties+=Property*)
     *     )
     * </pre>
     */
                protected void sequence_ProductChangeNoTransferType(ISerializationContext context, ProductChange semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ProductChange returns ProductChange
     *
     * Constraint:
     *     (
     *         (
     *             product=[ProductDefinition|ID] 
     *             slot=IID? 
     *             (startProperties+=Property startProperties+=Property*)? 
     *             (endProperties+=Property endProperties+=Property*)?
     *         ) | 
     *         (slot=IID (startProperties+=Property startProperties+=Property*)? (endProperties+=Property endProperties+=Property*)?) | 
     *         (startProperties+=Property startProperties+=Property* (endProperties+=Property endProperties+=Property*)?) | 
     *         (endProperties+=Property endProperties+=Property*) | 
     *         (
     *             transferType=TransferType 
     *             product=[ProductDefinition|ID]? 
     *             slot=IID? 
     *             (startProperties+=Property startProperties+=Property*)? 
     *             (endProperties+=Property endProperties+=Property*)?
     *         )
     *     )
     * </pre>
     */
                protected void sequence_ProductChangeNoTransferType_ProductChangeWithTransferType(ISerializationContext context, ProductChange semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ProductChangeWithTransferType returns ProductChange
     *
     * Constraint:
     *     (
     *         transferType=TransferType 
     *         product=[ProductDefinition|ID]? 
     *         slot=IID? 
     *         (startProperties+=Property startProperties+=Property*)? 
     *         (endProperties+=Property endProperties+=Property*)?
     *     )
     * </pre>
     */
                protected void sequence_ProductChangeWithTransferType(ISerializationContext context, ProductChange semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ProfileDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (declarations+=ProfileDef declarations+=ProfileDef*)
     * </pre>
     */
                protected void sequence_ProfileDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ProfileDef returns Profile
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_ProfileDef(ISerializationContext context, Profile semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getProfileDefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Property returns Property
     *
     * Constraint:
     *     (definition=[PropertyDefinition|ID] (value=BooleanValue | value=IntegerValue | value=StringValue))
     * </pre>
     */
                protected void sequence_Property(ISerializationContext context, Property semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns RaiseEvent
     *     RaiseEvent returns RaiseEvent
     *
     * Constraint:
     *     (name=ID resourceDefinition=[Event|ID] resourceItem=[EventItem|ID]?)
     * </pre>
     */
                protected void sequence_RaiseEvent(ISerializationContext context, RaiseEvent semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns Release
     *     Release returns Release
     *
     * Constraint:
     *     (
     *         name=ID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         resourceDefinition=[Resource|ID] 
     *         resourceItem=[ResourceItem|IID]? 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_Release(ISerializationContext context, Release semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns RequireEvent
     *     RequireEvent returns RequireEvent
     *
     * Constraint:
     *     (name=ID resourceDefinition=[Event|ID] resourceItem=[EventItem|ID]?)
     * </pre>
     */
                protected void sequence_RequireEvent(ISerializationContext context, RequireEvent semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ResourceDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (declarations+=ResourceDef declarations+=ResourceDef*)
     * </pre>
     */
                protected void sequence_ResourceDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     ResourceDef returns Resource
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_ResourceDef(ISerializationContext context, Resource semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getResourceDefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     Node returns SimpleAction
     *     SimpleAction returns SimpleAction
     *
     * Constraint:
     *     (
     *         name=ID 
     *         (entry=TracePoint | (outerEntry=TracePoint entry=TracePoint))? 
     *         (resourceDefinition=[Resource|ID] resourceItem=[ResourceItem|IID]? peripheral=[Peripheral|ID])? 
     *         type=[ActionType|ID] 
     *         schedulingType=Scheduling? 
     *         (productChanges+=ProductChange productChanges+=ProductChangeWithTransferType*)? 
     *         (exit=TracePoint | (exit=TracePoint outerExit=TracePoint))?
     *     )
     * </pre>
     */
                protected void sequence_SimpleAction(ISerializationContext context, SimpleAction semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     SourceReference returns SourceReference
     *
     * Constraint:
     *     (node=[Action|ID] | node=[SyncBar|ID])
     * </pre>
     */
                protected void sequence_SourceReference(ISerializationContext context, SourceReference semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     StringValue returns StringValue
     *
     * Constraint:
     *     value=EString
     * </pre>
     */
                protected void sequence_StringValue(ISerializationContext context, StringValue semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ProductPackage.Literals.STRING_VALUE__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ProductPackage.Literals.STRING_VALUE__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getStringValueAccess().getValueEStringParserRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     SymbolicPositionDeclaration returns ParameterDeclaration
     *
     * Constraint:
     *     (declarations+=SymbolicPositionDef declarations+=SymbolicPositionDef*)
     * </pre>
     */
                protected void sequence_SymbolicPositionDeclaration(ISerializationContext context, ParameterDeclaration semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     SymbolicPositionDef returns SymbolicPosition
     *
     * Constraint:
     *     name=ID
     * </pre>
     */
                protected void sequence_SymbolicPositionDef(ISerializationContext context, SymbolicPosition semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, CommonPackage.Literals.HAS_NAME__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CommonPackage.Literals.HAS_NAME__NAME));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getSymbolicPositionDefAccess().getNameIDTerminalRuleCall_1_0(), semanticObject.getName());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     DependencyTarget returns TargetReference
     *     TargetReference returns TargetReference
     *
     * Constraint:
     *     (node=[Action|ID] | node=[SyncBar|ID])
     * </pre>
     */
                protected void sequence_TargetReference(ISerializationContext context, TargetReference semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

    /**
     * <pre>
     * Contexts:
     *     TimeConstraintEdge returns Dependency
     *
     * Constraint:
     *     (source=SourceReference bounds=TimeConstraint target=DependencyTarget)
     * </pre>
     */
                protected void sequence_TimeConstraintEdge(ISerializationContext context, Dependency semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__SOURCE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__SOURCE));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.DEPENDENCY__BOUNDS) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.DEPENDENCY__BOUNDS));
        if (transientValues.isValueTransient(semanticObject, EdgPackage.Literals.EDGE__TARGET) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EdgPackage.Literals.EDGE__TARGET));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getTimeConstraintEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0(), semanticObject.getSource());
    feeder.accept(grammarAccess.getTimeConstraintEdgeAccess().getBoundsTimeConstraintParserRuleCall_3_0(), semanticObject.getBounds());
    feeder.accept(grammarAccess.getTimeConstraintEdgeAccess().getTargetDependencyTargetParserRuleCall_5_0(), semanticObject.getTarget());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     TimeConstraint returns TimeBounds
     *
     * Constraint:
     *     (lower=EBigDecimal upper=EBigDecimal)
     * </pre>
     */
                protected void sequence_TimeConstraint(ISerializationContext context, TimeBounds semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__LOWER) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__LOWER));
        if (transientValues.isValueTransient(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__UPPER) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ActivityPackage.Literals.TIME_BOUNDS__UPPER));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getTimeConstraintAccess().getLowerEBigDecimalParserRuleCall_1_0(), semanticObject.getLower());
    feeder.accept(grammarAccess.getTimeConstraintAccess().getUpperEBigDecimalParserRuleCall_3_0(), semanticObject.getUpper());
    feeder.finish();
    }
    

    /**
     * <pre>
     * Contexts:
     *     TracePoint returns TracePoint
     *
     * Constraint:
     *     (regex?='~'? value=EString)
     * </pre>
     */
                protected void sequence_TracePoint(ISerializationContext context, TracePoint semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    

}
