/*
 * Decompiled with CFR 0.152.
 */
package distributions.math;

import distributions.math.ModeDistribution;
import java.util.Arrays;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;

public class PoissonModeDistribution
extends PoissonDistribution
implements ModeDistribution {
    private static final long serialVersionUID = 1L;
    private final Double itsDefault;

    public PoissonModeDistribution(RandomGenerator rng, double p, Double epsilon, Double _default) throws NotStrictlyPositiveException {
        super(rng, p, epsilon == null ? 1.0E-12 : epsilon, 10000000);
        this.itsDefault = _default;
    }

    @Override
    public double getMode() {
        return this.getNumericalMean();
    }

    @Override
    public double getDefault() {
        if (this.itsDefault != null) {
            return this.itsDefault;
        }
        return this.getNumericalMean();
    }

    @Override
    public double density(double x) {
        if (Math.abs(x - (double)Math.round(x)) < 1.0E-10) {
            return this.probability(Math.round((int)x));
        }
        return 0.0;
    }

    @Override
    public double getLowerBound() {
        return this.getSupportLowerBound();
    }

    @Override
    public double getUpperBound() {
        return this.getSupportUpperBound();
    }

    @Override
    public double nextSample() {
        return this.sample();
    }

    @Override
    public double[] nextSamples(int sampleSize) {
        return Arrays.stream(super.sample(sampleSize)).mapToDouble(i -> i).toArray();
    }
}

